/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;

public class BlockModelModifierBakedModel
implements IBakedModel,
CustomRenderTypeBakedModel {
    private final IBakedModel original;
    private final List<IBakedModel> models;
    private final boolean hasNonSimpleModels;
    private final List<IBakedModel> nonSimpleModels;
    private final List<BakedQuad> quads;
    private final List<BakedQuad>[] culledQuads = new List[6];
    private final Set<BlockRenderLayer> customBlockRenderTypes;

    public BlockModelModifierBakedModel(IBakedModel original, List<IBakedModel> models) {
        this.original = original;
        this.models = new ArrayList<IBakedModel>(models.size() + 1);
        this.models.add(original);
        this.models.addAll(models);
        ArrayList<IBakedModel> nonSimpleModels = new ArrayList<IBakedModel>();
        ArrayList quads = new ArrayList();
        List[] culledQuads = (List[])IntStream.range(0, 6).mapToObj(i -> new ArrayList()).toArray(List[]::new);
        HashSet<BlockRenderLayer> customBlockRenderTypes = new HashSet<BlockRenderLayer>();
        for (IBakedModel model : this.models) {
            if (!model.getClass().equals(SimpleBakedModel.class)) {
                nonSimpleModels.add(model);
                if (!(model instanceof CustomRenderTypeBakedModel)) continue;
                customBlockRenderTypes.addAll(((CustomRenderTypeBakedModel)model).getBlockRenderTypes());
                continue;
            }
            quads.addAll(model.func_188616_a(null, null, 42L));
            for (EnumFacing side : EnumFacing.values()) {
                culledQuads[side.ordinal()].addAll(model.func_188616_a(null, side, 42L));
            }
        }
        this.hasNonSimpleModels = !nonSimpleModels.isEmpty();
        this.nonSimpleModels = nonSimpleModels.isEmpty() ? null : ImmutableList.copyOf(nonSimpleModels);
        this.quads = ImmutableList.copyOf(quads);
        for (EnumFacing side : EnumFacing.values()) {
            this.culledQuads[side.ordinal()] = ImmutableList.copyOf((Collection)culledQuads[side.ordinal()]);
        }
        this.customBlockRenderTypes = ImmutableSet.copyOf(customBlockRenderTypes);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long random) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (IBakedModel nonSimpleModel : this.nonSimpleModels) {
            quads.addAll(nonSimpleModel.func_188616_a(state, side, random));
        }
        return quads;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Override
    public Collection<BlockRenderLayer> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.original.isAmbientOcclusion(state);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
        return this.original.handlePerspective(transformType);
    }

    public boolean func_177555_b() {
        return this.original.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }
}

