/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;

public class ConnectingModelDataImpl
extends BaseModelDataImpl
implements ConnectingModelData {
    private final Map<String, ConnectionPredicate> predicates;
    private final Map<String, String> connectionReferences;

    public ConnectingModelDataImpl(ModelBlock model, List<ResourceLocation> parents, List<ConnectingModelElement> elements, Map<String, ConnectionPredicate> predicates, Map<String, String> references) {
        super(model, parents, elements);
        this.predicates = ImmutableMap.copyOf(predicates);
        this.connectionReferences = ImmutableMap.copyOf(references);
    }

    public List<ConnectingModelElement> getElements() {
        return super.getElements();
    }

    @Override
    public ConnectionPredicate getConnectionPredicate(String texture) {
        return this.predicates.get(texture);
    }

    @Override
    public ConnectionPredicate getDefaultConnectionPredicate() {
        return this.getConnectionPredicate("default");
    }

    @Override
    public Map<String, ConnectionPredicate> getAllConnectionPredicates() {
        return this.predicates;
    }

    public Map<String, String> getConnectionReferences() {
        return this.connectionReferences;
    }

    @Override
    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.CONNECTING, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List<BlockPart> elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).getElements();
        } else {
            ModelBlock vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel == ModelBakery.field_177606_o ? this.generateItemModel(context, modelStack) : vanillaModel.field_178314_g;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockPart element : elements) {
                for (EnumFacing direction : element.field_178240_c.keySet()) {
                    BlockPartFace face = (BlockPartFace)element.field_178240_c.get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context::getModel, modelStack, face.field_178242_d, context.getModelIdentifier()));
                    BakedQuad quad = FACE_BAKERY.makeBakedQuad(element.field_178241_a, element.field_178239_b, face, sprite, direction, (ITransformation)context.getTransformation().apply(Optional.empty()).orElse(TRSRTransformation.identity()), element.field_178237_d, false, element.field_178238_e);
                    EnumFacing cullDirection = face.field_178244_b == null ? null : context.getTransformation().apply(Optional.empty()).map(t -> t.rotate(face.field_178244_b)).orElse(face.field_178244_b);
                    Integer lightEmission = element instanceof BaseModelElement ? ((BaseModelElement)element).light_emission : null;
                    String connectionsKey = element instanceof ConnectingModelElement && ((ConnectingModelElement)element).faceConnectionKeys.containsKey(direction) ? ((ConnectingModelElement)element).faceConnectionKeys.get(direction) : face.field_178242_d;
                    ConnectionPredicate predicate = this.resolveConnectionKey(context, modelStack, connectionsKey);
                    output.accept(new ConnectingModelQuad(quad, cullDirection, lightEmission, predicate));
                }
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    private ConnectionPredicate resolveConnectionKey(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            String newKey = null;
            for (ModelInstance<?> model : modelStack) {
                if (model.getModelType() != DefaultModelTypes.CONNECTING) continue;
                ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(currentKey);
                if (predicate != null) {
                    return predicate;
                }
                String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(currentKey);
                if (reference == null) continue;
                newKey = reference;
                break;
            }
            if (newKey == null) {
                for (ModelInstance<?> model : modelStack) {
                    String value;
                    ModelBlock vanillaModel = model.getAsVanillaModel();
                    if (vanillaModel == null || (value = (String)vanillaModel.field_178318_c.get(currentKey)) == null) continue;
                    newKey = value;
                    break;
                }
            }
            if (newKey == null) {
                Either<ConnectionPredicate, String> entry = ConnectingModelDataImpl.findConnectionsEntry(context, modelStack.getLast(), currentKey);
                if (entry != null && entry.isLeft()) {
                    return entry.left();
                }
                if (entry != null && entry.isRight()) {
                    newKey = entry.right();
                }
            }
            if (newKey == null && !currentKey.equals("default")) {
                newKey = "default";
            }
            if (newKey == null) {
                return null;
            }
            currentKey = newKey;
            if (currentKey.charAt(0) == '#') {
                currentKey = currentKey.substring(1);
            }
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve connections due to circular references {}->'{}' in '{}'!", (Object)encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), (Object)currentKey, (Object)context.getModelIdentifier());
                return null;
            }
            encounteredKeys.add(currentKey);
        }
    }

    private static Either<ConnectionPredicate, String> findConnectionsEntry(ModelBakingContext context, ModelInstance<?> model, String key) {
        if (model.getModelType() == DefaultModelTypes.CONNECTING) {
            ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(key);
            if (predicate != null) {
                return Either.left(predicate);
            }
            String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(key);
            if (reference != null) {
                return Either.right(reference);
            }
        }
        for (ResourceLocation location : model.getParentModels()) {
            Either<ConnectionPredicate, String> entry;
            ModelInstance<?> parent = context.getModel(location);
            if (parent == null || (entry = ConnectingModelDataImpl.findConnectionsEntry(context, parent, key)) == null) continue;
            return entry;
        }
        return null;
    }
}

