/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MatchStateConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchStateConnectionPredicate> SERIALIZER = new Serializer<MatchStateConnectionPredicate>(){

        @Override
        public MatchStateConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match state predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            if (!ForgeRegistries.BLOCKS.containsKey(identifier)) {
                throw new JsonParseException("Unknown block '" + identifier + "'!");
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(identifier);
            ArrayList<Pair<IProperty<?>, Set<?>>> properties = new ArrayList();
            if (!json.has("properties") || !json.get("properties").isJsonObject()) {
                throw new JsonParseException("Match block predicate must have object property 'properties'!");
            }
            if (json.getAsJsonObject("properties").size() == 0) {
                throw new JsonParseException("At least one property must be specified for match state predicate!");
            }
            for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
                IProperty property = block.func_176194_O().func_185920_a((String)entry.getKey());
                if (property == null) {
                    throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    Optional value = property.func_185929_b(((JsonElement)entry.getValue()).getAsString());
                    if (!value.isPresent()) {
                        throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                    if (((JsonElement)entry.getValue()).getAsJsonArray().size() == 0) {
                        throw new JsonParseException("Valid values for property '" + property.func_177701_a() + "' cannot be empty!");
                    }
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                        }
                        Optional value = property.func_185929_b(element.getAsString());
                        if (!value.isPresent()) {
                            throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                        }
                        builder.add(value.get());
                    }
                } else {
                    throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                }
                properties.add(Pair.of(property, builder.build()));
            }
            properties = Arrays.asList(properties.toArray(new Pair[0]));
            return new MatchStateConnectionPredicate(block, properties);
        }

        @Override
        public JsonObject serialize(MatchStateConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)value.block).toString());
            JsonObject properties = new JsonObject();
            value.properties.stream().map(p -> p.mapRight(values -> {
                JsonArray array = new JsonArray();
                values.stream().map(v -> ((IProperty)p.left()).func_177702_a((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            })).map(p -> p.mapLeft(IProperty::func_177701_a)).sorted(Comparator.comparing(Pair::left)).forEach(pair -> properties.add((String)pair.left(), (JsonElement)pair.right()));
            json.add("properties", (JsonElement)properties);
            return json;
        }
    };
    private final Block block;
    private final List<Pair<IProperty<?>, Set<?>>> properties;
    private boolean compareStates = false;
    private Set<IBlockState> states = null;

    public MatchStateConnectionPredicate(Block block, List<Pair<IProperty<?>, Set<?>>> properties) {
        this.block = block;
        this.properties = properties;
        this.computeStates();
    }

    @SafeVarargs
    public MatchStateConnectionPredicate(Block block, Pair<IProperty<?>, ?> ... propertyPair) {
        this.block = block;
        HashMap<IProperty, List> propertyMap = new HashMap<IProperty, List>();
        for (Pair<IProperty<?>, ?> pair : propertyPair) {
            IProperty<?> property = pair.left();
            if (!block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property.func_177701_a() + "' is not a property of block '" + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block) + "'!");
            }
            Object value = pair.right();
            if (!property.func_177700_c().contains(value)) {
                throw new IllegalArgumentException("Invalid value '" + value + "' for property '" + property.func_177701_a() + "'!");
            }
            propertyMap.computeIfAbsent(property, p -> new ArrayList()).add(value);
        }
        Pair[] properties = new Pair[propertyMap.size()];
        int index = 0;
        for (Map.Entry entry : propertyMap.entrySet()) {
            properties[index++] = Pair.of(entry.getKey(), ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.properties = Arrays.asList(properties);
        this.computeStates();
    }

    private <T extends Comparable<T>> void computeStates() {
        HashSet unrestrictedProperties = new HashSet(this.block.func_176194_O().func_177623_d());
        int validStates = 1;
        for (Pair<IProperty<?>, Set<?>> pair : this.properties) {
            validStates *= pair.right().size();
            unrestrictedProperties.remove(pair.left());
        }
        for (IProperty property : unrestrictedProperties) {
            validStates *= property.func_177700_c().size();
        }
        if (validStates > 64) {
            return;
        }
        Stream<Object> states = Stream.of(this.block.func_176194_O().func_177621_b());
        for (Pair<IProperty<?>, Set<?>> pair : this.properties) {
            IProperty<?> property = pair.left();
            Set<?> values = pair.right();
            states = states.flatMap(state -> values.stream().map(value -> state.func_177226_a(property, (Comparable)value)));
        }
        for (IProperty property : unrestrictedProperties) {
            states = states.flatMap(state -> property.func_177700_c().stream().map(value -> state.func_177226_a(property, value)));
        }
        this.compareStates = true;
        this.states = (Set)states.collect(ImmutableSet.toImmutableSet());
        if (this.states.size() != validStates) {
            throw new AssertionError((Object)("Got two different numbers of valid states: " + validStates + " and " + this.states.size() + "!"));
        }
    }

    @Override
    public boolean shouldConnect(EnumFacing side, @Nullable IBlockState ownState, IBlockState otherState, IBlockState blockInFront, ConnectionDirection direction) {
        if (this.compareStates) {
            return this.states.contains(otherState);
        }
        if (otherState.func_177230_c() != this.block) {
            return false;
        }
        for (Pair<IProperty<?>, Set<?>> property : this.properties) {
            if (property.right().contains(otherState.func_177229_b(property.left()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof MatchStateConnectionPredicate)) {
            return false;
        }
        MatchStateConnectionPredicate that = (MatchStateConnectionPredicate)o;
        return this.block.equals(that.block) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

