/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.util.Serializer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class OrConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<OrConnectionPredicate> SERIALIZER = new Serializer<OrConnectionPredicate>(){

        @Override
        public OrConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicates") || !json.get("predicates").isJsonArray()) {
                throw new JsonParseException("Or-predicate must have array property 'predicates'!");
            }
            ArrayList<ConnectionPredicate> predicates = new ArrayList<ConnectionPredicate>();
            JsonArray array = json.getAsJsonArray("predicates");
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Property 'predicates' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
                predicates.add(predicate);
            }
            return new OrConnectionPredicate(predicates);
        }

        @Override
        public JsonObject serialize(OrConnectionPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray predicatesJson = new JsonArray();
            for (ConnectionPredicate predicate : value.predicates) {
                predicatesJson.add((JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate));
            }
            json.add("predicates", (JsonElement)predicatesJson);
            return json;
        }
    };
    private final List<ConnectionPredicate> predicates;
    private final boolean isSensitive;

    public OrConnectionPredicate(List<ConnectionPredicate> predicates) {
        this.predicates = predicates;
        this.isSensitive = predicates.stream().anyMatch(ConnectionPredicate::isSensitive);
    }

    @Override
    public boolean shouldConnect(EnumFacing side, @Nullable IBlockState ownState, IBlockState otherState, IBlockState blockInFront, ConnectionDirection direction) {
        for (ConnectionPredicate predicate : this.predicates) {
            if (!predicate.shouldConnect(side, ownState, otherState, blockInFront, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldConnect(IBlockAccess level, BlockPos pos, EnumFacing side, @Nullable IBlockState ownState, IBlockState otherState, IBlockState blockInFront, ConnectionDirection direction) {
        for (ConnectionPredicate predicate : this.predicates) {
            if (!predicate.shouldConnect(level, pos, side, ownState, otherState, blockInFront, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSensitive() {
        return this.isSensitive;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrConnectionPredicate)) {
            return false;
        }
        OrConnectionPredicate that = (OrConnectionPredicate)o;
        return this.predicates.equals(that.predicates);
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }
}

