/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import com.supermartijn642.fusion.util.TextureAtlases;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;

public class VanillaModelType
implements ModelType<ModelBlock> {
    public static ModelLoader modelLoader;
    private static final ModelBlockAnimation defaultModelBlockAnimation;
    private static final Constructor<? extends IModel> vanillaModelWrapperConstructor;

    @Override
    public Collection<ResourceLocation> getModelDependencies(ModelBlock data) {
        return VanillaModelType.getAsForgeModel(data).getDependencies();
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, ModelBlock data) {
        VanillaModelType.resolveParents(context, data);
        Collection materials = VanillaModelType.getAsForgeModel(data).getTextures();
        return materials.stream().map(t -> SpriteIdentifier.of(TextureAtlases.getBlocks(), t)).collect(Collectors.toList());
    }

    @Override
    public IBakedModel bake(ModelBakingContext context, ModelBlock data) {
        if (data.field_178316_e != null && data.field_178315_d == null) {
            VanillaModelType.resolveParents(context::getModel, data);
        }
        return VanillaModelType.getAsForgeModel(data).bake(context.getTransformation(), DefaultVertexFormats.field_176600_a, material -> context.getTexture(SpriteIdentifier.of(TextureAtlases.getBlocks(), material)));
    }

    @Override
    @Nullable
    public ModelBlock getAsVanillaModel(ModelBlock data) {
        return data;
    }

    @Override
    public ModelBlock deserialize(JsonObject json) throws JsonParseException {
        return (ModelBlock)ModelBlock.field_178319_a.fromJson((JsonElement)json, ModelBlock.class);
    }

    @Override
    public JsonObject serialize(ModelBlock value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }

    private static IModel getAsForgeModel(ModelBlock model) {
        IModel wrapper = ((BlockModelExtension)model).getWrapper();
        if (wrapper == null) {
            try {
                vanillaModelWrapperConstructor.newInstance(modelLoader, new ResourceLocation(model.field_178317_b), model, false, defaultModelBlockAnimation);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            wrapper = ((BlockModelExtension)model).getWrapper();
        }
        return wrapper;
    }

    public static void resolveParents(GatherTexturesContext context, ModelBlock model) {
        LinkedHashSet<ModelBlock> passedModels = new LinkedHashSet<ModelBlock>();
        while (model.field_178316_e != null && model.field_178315_d == null) {
            passedModels.add(model);
            ModelInstance<?> modelInstance = context.getModel(model.field_178316_e);
            if (modelInstance == null) {
                return;
            }
            ModelBlock parent = modelInstance.getAsVanillaModel();
            if (parent == null) {
                ModelBlock.field_178313_f.warn("Vanilla model {} cannot have parent with model type {} for {}!", (Object)model, modelInstance.getModelType(), (Object)model.field_178316_e);
            }
            if (passedModels.contains(parent)) {
                ModelBlock.field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)model, (Object)passedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)model.field_178316_e);
                parent = null;
            }
            if (parent == null) {
                model.field_178316_e = ModelBakery.field_177604_a;
                parent = context.getModel(model.field_178316_e).getAsVanillaModel();
                if (parent == null) {
                    throw new RuntimeException("Got null for missing model request!");
                }
            }
            model.field_178315_d = parent;
            model = parent;
        }
    }

    static {
        defaultModelBlockAnimation = new ModelBlockAnimation(ImmutableMap.of(), ImmutableMap.of());
        Class vanillaModelWrapperClass = Arrays.stream(ModelLoader.class.getDeclaredClasses()).filter(aClass -> aClass.getName().equals("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper")).findFirst().get();
        vanillaModelWrapperConstructor = vanillaModelWrapperClass.getDeclaredConstructors()[0];
        vanillaModelWrapperConstructor.setAccessible(true);
    }
}

