/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public class QuadTintingHelper {
    private static final IBlockColor[] TINT_FUNCTIONS = new IBlockColor[]{(state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        }
        return BiomeColorHelper.func_180286_a((IBlockAccess)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return ColorizerFoliage.func_77468_c();
        }
        return BiomeColorHelper.func_180287_b((IBlockAccess)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return -1;
        }
        return BiomeColorHelper.func_180288_c((IBlockAccess)level, (BlockPos)pos);
    }};

    public static int getColor(BaseTextureData.QuadTinting tinting, IBlockState state, IBlockAccess level, BlockPos pos) {
        IBlockColor tintFunction = TINT_FUNCTIONS[tinting.ordinal()];
        return tintFunction.func_186720_a(state, level, pos, 0) | 0xFF000000;
    }

    static {
        if (TINT_FUNCTIONS.length != BaseTextureData.QuadTinting.values().length) {
            throw new AssertionError((Object)"Missing tinting functions!");
        }
    }
}

