/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting.layouts;

import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;

public class OverlayLayoutHandler
extends ConnectingTextureLayoutHandler {
    private final int[][][] uvs = new int[4][(int)Math.pow(2.0, 8.0)][];

    public OverlayLayoutHandler() {
        super(6, 3, 1, 1, 3);
        for (TextureConnections connections : TextureConnections.iterateAll()) {
            int index = this.connectionsIndex(connections);
            for (int quad = 0; quad < 4; ++quad) {
                this.uvs[quad][index] = this.getTilePos(quad, connections);
            }
        }
    }

    private int connectionsIndex(TextureConnections connections) {
        return (connections.top ? 1 : 0) | (connections.topRight ? 2 : 0) | (connections.right ? 4 : 0) | (connections.bottomRight ? 8 : 0) | (connections.bottom ? 16 : 0) | (connections.bottomLeft ? 32 : 0) | (connections.left ? 64 : 0) | (connections.topLeft ? 128 : 0);
    }

    private int[] getTilePos(int quadIndex, TextureConnections connections) {
        if (connections.top && connections.right && connections.bottom && connections.left) {
            int[] nArray;
            if (quadIndex == 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 4;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                nArray = null;
            }
            return nArray;
        }
        if (!(connections.top || connections.topRight || connections.right || connections.bottomRight || connections.bottom || connections.bottomLeft || connections.left || connections.topLeft)) {
            return null;
        }
        if (quadIndex == 0) {
            if (connections.left) {
                return null;
            }
            if (!connections.top) {
                int[] nArray;
                if (connections.topLeft) {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 2;
                    nArray = nArray3;
                    nArray3[1] = 2;
                } else {
                    nArray = null;
                }
                return nArray;
            }
            if (!connections.right) {
                return new int[]{1, 2};
            }
            if (!connections.bottom) {
                return new int[]{3, 2};
            }
            return new int[]{3, 1};
        }
        if (quadIndex == 1) {
            if (connections.top) {
                return null;
            }
            if (!connections.right) {
                int[] nArray;
                if (connections.topRight) {
                    int[] nArray4 = new int[2];
                    nArray4[0] = 0;
                    nArray = nArray4;
                    nArray4[1] = 2;
                } else {
                    nArray = null;
                }
                return nArray;
            }
            if (!connections.bottom) {
                return new int[]{0, 1};
            }
            if (!connections.left) {
                return new int[]{3, 0};
            }
            return new int[]{4, 0};
        }
        if (quadIndex == 2) {
            if (connections.right) {
                return null;
            }
            if (!connections.bottom) {
                int[] nArray;
                if (connections.bottomRight) {
                    int[] nArray5 = new int[2];
                    nArray5[0] = 0;
                    nArray = nArray5;
                    nArray5[1] = 0;
                } else {
                    nArray = null;
                }
                return nArray;
            }
            if (!connections.left) {
                return new int[]{1, 0};
            }
            if (!connections.top) {
                return new int[]{5, 0};
            }
            return new int[]{5, 1};
        }
        if (quadIndex == 3) {
            if (connections.bottom) {
                return null;
            }
            if (!connections.left) {
                int[] nArray;
                if (connections.bottomLeft) {
                    int[] nArray6 = new int[2];
                    nArray6[0] = 2;
                    nArray = nArray6;
                    nArray6[1] = 0;
                } else {
                    nArray = null;
                }
                return nArray;
            }
            if (!connections.top) {
                return new int[]{2, 1};
            }
            if (!connections.right) {
                return new int[]{5, 2};
            }
            return new int[]{4, 2};
        }
        return null;
    }

    @Override
    public boolean processBlockQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite, TextureConnections connections) {
        int[] tile = this.uvs[quadIndex][this.connectionsIndex(connections)];
        if (tile == null) {
            return false;
        }
        if (sprite.field_130222_e) {
            OverlayLayoutHandler.adjustQuadUV(quad, tile[1], tile[0], sprite);
        } else {
            OverlayLayoutHandler.adjustQuadUV(quad, tile[0], tile[1], sprite);
        }
        return true;
    }

    @Override
    public boolean processItemQuad(int quadIndex, MutableQuad quad, ConnectingTextureSprite sprite) {
        return false;
    }

    private static void adjustQuadUV(MutableQuad quad, int tileU, int tileV, ConnectingTextureSprite sprite) {
        for (int i = 0; i < 4; ++i) {
            float width = sprite.func_94212_f() - sprite.func_94209_e();
            float u = sprite.getStartU() + quad.u(i) - sprite.func_94209_e() + width * (float)tileU;
            float height = sprite.func_94210_h() - sprite.func_94206_g();
            float v = sprite.getStartV() + quad.v(i) - sprite.func_94206_g() + height * (float)tileV;
            quad.uv(i, u, v);
        }
    }
}

