/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;

public class IsDirectionConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<IsDirectionConnectionPredicate> SERIALIZER = new Serializer<IsDirectionConnectionPredicate>(){

        @Override
        public IsDirectionConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("direction") && !json.get("directions").isJsonArray()) {
                throw new JsonParseException("Is-direction-predicate must have at least one of 'direction' or 'directions'!");
            }
            HashSet<ConnectionDirection> directions = new HashSet<ConnectionDirection>();
            if (json.has("direction")) {
                this.readDirections("direction", json.get("direction"), directions);
            }
            if (json.has("directions")) {
                this.readDirections("directions", json.get("directions"), directions);
            }
            if (directions.isEmpty()) {
                throw new JsonParseException("Is-direction-predicate must contain at least one valid direction!");
            }
            return new IsDirectionConnectionPredicate(directions.toArray(new ConnectionDirection[0]));
        }

        private void readDirections(String propertyName, JsonElement json, Set<ConnectionDirection> output) {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                ConnectionDirection direction;
                try {
                    direction = ConnectionDirection.valueOf(json.getAsString().toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("Property '" + propertyName + "' has unknown direction '" + json.getAsString() + "'!");
                }
                if (!output.add(direction)) {
                    throw new JsonParseException("Duplicate direction '" + (Object)((Object)direction) + "'!");
                }
            } else if (json.isJsonArray()) {
                for (JsonElement element : json.getAsJsonArray()) {
                    ConnectionDirection direction;
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + propertyName + "' must only contain strings!");
                    }
                    try {
                        direction = ConnectionDirection.valueOf(element.getAsString().toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonParseException("Property '" + propertyName + "' has unknown direction '" + element.getAsString() + "'!");
                    }
                    if (output.add(direction)) continue;
                    throw new JsonParseException("Duplicate direction '" + (Object)((Object)direction) + "'!");
                }
            } else {
                throw new JsonParseException("Property '" + propertyName + "' must be a string or an array of strings!");
            }
        }

        @Override
        public JsonObject serialize(IsDirectionConnectionPredicate value) {
            JsonObject json = new JsonObject();
            List<String> directions = Arrays.stream(ConnectionDirection.values()).filter(d -> value.directions[d.ordinal()]).map(d -> d.name().toLowerCase(Locale.ROOT)).sorted().collect(Collectors.toList());
            if (directions.size() == 1) {
                json.addProperty("direction", (String)directions.get(0));
            } else {
                JsonArray directionsArray = new JsonArray();
                directions.forEach(arg_0 -> ((JsonArray)directionsArray).add(arg_0));
                json.add("directions", (JsonElement)directionsArray);
            }
            return json;
        }
    };
    private final boolean[] directions = new boolean[ConnectionDirection.values().length];

    public IsDirectionConnectionPredicate(ConnectionDirection ... directions) {
        if (directions.length == 0) {
            throw new IllegalArgumentException("Is-direction-predicate must contain at least one valid direction!");
        }
        for (ConnectionDirection direction : directions) {
            this.directions[direction.ordinal()] = true;
        }
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        return this.directions[direction.ordinal()];
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof IsDirectionConnectionPredicate)) {
            return false;
        }
        IsDirectionConnectionPredicate that = (IsDirectionConnectionPredicate)o;
        return Arrays.equals(this.directions, that.directions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.directions);
    }
}

