/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class SpriteCreationContextImpl
implements SpriteCreationContext,
AutoCloseable {
    private final TextureAtlasSprite original;
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation identifier;
    private final NativeImage[] images;
    private final int atlasWidth;
    private final int atlasHeight;
    private final AtlasTexture atlas;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final int mipmapLevels;
    private boolean imagesRequested = false;

    public SpriteCreationContextImpl(TextureAtlasSprite original, AtlasTexture atlas) {
        this.original = original;
        this.textureWidth = original.field_195670_c[0].func_195702_a();
        this.textureHeight = original.field_195670_c[0].func_195714_b();
        this.identifier = original.func_195668_m();
        this.images = original.field_195670_c;
        this.atlasWidth = Math.round((float)(original.field_110975_c + original.func_94211_a()) / original.func_94212_f());
        this.atlasHeight = Math.round((float)(original.field_110974_d + original.func_94216_b()) / original.func_94210_h());
        this.atlas = atlas;
        this.spriteX = original.field_110975_c;
        this.spriteY = original.field_110974_d;
        this.spriteWidth = original.func_94211_a();
        this.spriteHeight = original.func_94216_b();
        this.mipmapLevels = original.field_195670_c.length - 1;
    }

    private void closeUnusedResources() {
        if (!this.imagesRequested) {
            this.original.func_130103_l();
        }
    }

    @Override
    public TextureAtlasSprite createOriginalSprite() {
        this.imagesRequested = true;
        return this.original;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public ResourceLocation getTextureIdentifier() {
        return this.identifier;
    }

    @Override
    public NativeImage[] getTextureBuffers() {
        this.imagesRequested = true;
        return this.images;
    }

    @Override
    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    @Override
    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    @Override
    public AtlasTexture getAtlas() {
        return this.atlas;
    }

    @Override
    public int getSpritePositionX() {
        return this.spriteX;
    }

    @Override
    public int getSpritePositionY() {
        return this.spriteY;
    }

    @Override
    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    @Override
    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    @Override
    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    @Override
    public void close() {
        this.closeUnusedResources();
    }
}

