/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.ResourcePackExtension;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FolderResourcePack.class})
public abstract class FolderResourcePackMixin
extends AbstractResourcePack
implements ResourcePackExtension {
    @Unique
    private File overridesFolder;

    public FolderResourcePackMixin(File file) {
        super(file);
    }

    @Override
    public void setFusionOverridesFolder(@Nonnull String folder) {
        this.overridesFolder = new File(this.field_110597_b, folder);
    }

    @Override
    public Collection<ResourceLocation> fusionGetResources(String folder, int maxDepth, Predicate<String> filter) {
        File assetsFolder = new File(this.field_110597_b, "assets");
        File overwritesAssetsFolder = new File(this.overridesFolder, "assets");
        HashSet<ResourceLocation> resources = new HashSet<ResourceLocation>();
        for (String namespace : this.func_110587_b()) {
            this.listResources(new File(new File(assetsFolder, namespace), folder), maxDepth, namespace, resources, folder + "/", filter);
            this.listResources(new File(new File(overwritesAssetsFolder, namespace), folder), maxDepth, namespace, resources, folder + "/", filter);
        }
        return resources;
    }

    @Unique
    private void listResources(File currentFolder, int maxDepth, String namespace, Collection<ResourceLocation> resources, String folder, Predicate<String> filter) {
        File[] files = currentFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (file.isDirectory()) {
                    if (maxDepth <= 0) continue;
                    this.listResources(file, maxDepth - 1, namespace, resources, folder + fileName + "/", filter);
                    continue;
                }
                if (fileName.endsWith(".mcmeta") || !filter.test(fileName) || !IdentifierUtil.isValidPath(fileName)) continue;
                resources.add(new ResourceLocation(namespace, folder + fileName));
            }
        }
    }

    @Shadow
    private static boolean func_191384_a(File file, String path) throws IOException {
        throw new AssertionError();
    }

    @Inject(method={"getFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFile(String path, CallbackInfoReturnable<File> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        try {
            File file = new File(this.overridesFolder, path);
            if (file.isFile() && FolderResourcePackMixin.func_191384_a(file, path)) {
                ci.setReturnValue(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Inject(method={"getResourceDomains"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResourceDomains(CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)ci.getReturnValue());
        File typeFolder = new File(this.overridesFolder, "assets");
        if (typeFolder.isDirectory()) {
            File[] folders = typeFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            if (folders == null) {
                return;
            }
            for (File folder : folders) {
                String relativePath = AbstractResourcePack.func_110595_a((File)typeFolder, (File)folder);
                if (relativePath.equals(relativePath.toLowerCase(Locale.ROOT))) {
                    namespaces.add(relativePath.substring(0, relativePath.length() - 1));
                    continue;
                }
                FolderResourcePack.field_110598_a.warn("Ignored non-lowercase namespace: {} in {}", (Object)relativePath, (Object)((FolderResourcePack)this).field_110597_b);
            }
        }
        ci.setReturnValue(namespaces);
    }
}

