/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierReloadListener;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierReloadListener;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelLoader.class})
public class ModelLoaderMixin {
    @Shadow(remap=false)
    @Final
    private Map<ModelResourceLocation, IModel> stateModels;
    @Shadow(remap=false)
    @Final
    private Map<ResourceLocation, Exception> loadingExceptions;

    @Inject(method={"setupModelRegistry"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/model/ModelLoader;loadVariantItemModels()V", shift=At.Shift.AFTER)})
    private void loadModelsInject(CallbackInfoReturnable<?> ci) {
        HashSet<ModelResourceLocation> models = new HashSet<ModelResourceLocation>(BlockModelModifierReloadListener.INSTANCE.registerOverlays());
        models.addAll(ItemModelModifierReloadListener.INSTANCE.registerPredicateModels());
        for (ModelResourceLocation modelLocation : models) {
            IModel model;
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a()));
            }
            catch (Exception e) {
                this.loadingExceptions.put((ResourceLocation)modelLocation, e);
                model = ModelLoaderRegistry.getMissingModel();
            }
            this.stateModels.put(modelLocation, model);
        }
    }

    @Inject(method={"setupModelRegistry"}, at={@At(value="RETURN")})
    private void applyBakedModels(CallbackInfoReturnable<?> ci) {
        ModelBakery bakery = (ModelBakery)this;
        BlockModelModifierReloadListener.INSTANCE.applyOverlays(bakery);
        ItemModelModifierReloadListener.INSTANCE.applyPredicateModels(bakery);
    }
}

