/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.util.BlockRenderLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultipartBakedModel.class})
public class MultiPartBakedModelMixin
implements CustomRenderTypeBakedModel {
    @Unique
    private Set<BlockRenderLayer> customBlockRenderTypes;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(Map<Predicate<IBlockState>, IBakedModel> models, CallbackInfo ci) {
        HashSet<BlockRenderLayer> customBlockRenderTypes = null;
        for (IBakedModel model : models.values()) {
            Collection<BlockRenderLayer> renderTypes;
            if (!(model instanceof CustomRenderTypeBakedModel) || (renderTypes = ((CustomRenderTypeBakedModel)model).getBlockRenderTypes()).isEmpty()) continue;
            if (customBlockRenderTypes == null) {
                customBlockRenderTypes = new HashSet<BlockRenderLayer>();
            }
            customBlockRenderTypes.addAll(renderTypes);
        }
        this.customBlockRenderTypes = customBlockRenderTypes == null ? Collections.emptySet() : ImmutableSet.copyOf(customBlockRenderTypes);
    }

    @Override
    public Collection<BlockRenderLayer> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }
}

