/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.extensions.PackExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.ResourcePackListTipRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.ResourcePackListEntryFound;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ResourcePackListEntry.class})
public class PackEntryMixin {
    @Final
    @Shadow
    protected GuiScreenResourcePacks field_148315_b;
    @Unique
    private boolean cached = false;
    @Unique
    private ResourcePackRepository.Entry resourcePack;
    @Unique
    private FusionPackMetadata metadata;

    @Unique
    private void cacheFusionMetadata() {
        if (!this.cached) {
            this.cached = true;
            if (this instanceof ResourcePackListEntryFound) {
                this.resourcePack = ((ResourcePackListEntryFound)this).func_148318_i();
                this.metadata = ((PackExtension)this.resourcePack).getFusionMetadata();
            }
        }
    }

    @Inject(method={"drawEntry"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;drawModalRectWithCustomSizedTexture(IIFFIIFF)V", shift=At.Shift.BEFORE, ordinal=0)})
    private void renderBackground(int entryIndex, int left, int top, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        this.cacheFusionMetadata();
        if (this.metadata == null) {
            return;
        }
        ResourcePackListTipRenderer.renderBackground(this.metadata, this.resourcePack.func_183027_f() == 3, left, top, width, height);
    }

    @Inject(method={"drawEntry"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;drawModalRectWithCustomSizedTexture(IIFFIIFF)V", shift=At.Shift.AFTER, ordinal=0)})
    private void renderIcon(int entryIndex, int left, int top, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        this.cacheFusionMetadata();
        if (this.metadata == null) {
            return;
        }
        ResourcePackListTipRenderer.renderIcon(this.metadata, this.resourcePack.func_183027_f() == 3, left, top, width, height);
    }

    @ModifyVariable(method={"drawEntry"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/ResourcePackListEntry;canMoveRight()Z", shift=At.Shift.BEFORE), ordinal=1)
    private String adjustDescription(String label) {
        this.cacheFusionMetadata();
        if (this.metadata == null) {
            return label;
        }
        ITextComponent warningMessage = ResourcePackListTipRenderer.getWarningMessage(this.metadata, this.resourcePack.func_183027_f() == 3);
        return warningMessage == null ? label : warningMessage.func_150254_d();
    }

    @Inject(method={"mousePressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/ResourcePackListEntry;getResourcePackFormat()I", shift=At.Shift.BEFORE)}, cancellable=true)
    private void showFusionWarningScreen(CallbackInfoReturnable<Boolean> ci) {
        this.cacheFusionMetadata();
        if (this.metadata == null) {
            return;
        }
        int targetIndex = ((ResourcePackListEntry)this.field_148315_b.func_146963_h().get(0)).func_186768_j() ? 1 : 0;
        Consumer<Boolean> callback = select -> {
            List packs = this.field_148315_b.func_146962_b((ResourcePackListEntry)this);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.field_148315_b);
            if (select.booleanValue()) {
                packs.remove((ResourcePackListEntry)this);
                this.field_148315_b.func_146963_h().add(targetIndex, (ResourcePackListEntry)this);
            }
        };
        if (ResourcePackListTipRenderer.showWarningScreen(this.metadata, this.resourcePack.func_183027_f() == 3, this.resourcePack, callback)) {
            ci.setReturnValue(false);
        }
    }
}

