/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.ResourcePackExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.File;
import java.io.FileNotFoundException;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.client.resources.data.MetadataSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ResourcePackRepository.class})
public class ResourcePackRepositoryMixin {
    @Unique
    private static final MetadataSerializer METADATA_SERIALIZER = new MetadataSerializer();

    @Inject(method={"getResourcePack(Ljava/io/File;)Lnet/minecraft/client/resources/IResourcePack;"}, at={@At(value="RETURN")})
    private void getResourcePack(File file, CallbackInfoReturnable<IResourcePack> ci) {
        IResourcePack resources = ci.getReturnValue();
        if (resources instanceof ResourcePackExtension) {
            String overridesFolder;
            try {
                FusionPackMetadataSection.Data data = (FusionPackMetadataSection.Data)resources.func_135058_a(METADATA_SERIALIZER, FusionPackMetadataSection.INSTANCE.func_110483_a());
                overridesFolder = data == null ? null : data.metadata.getOverridesFolder();
            }
            catch (FileNotFoundException ignore) {
                return;
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading fusion metadata for pack '" + resources.func_130077_b() + "':", (Throwable)e);
                return;
            }
            if (overridesFolder != null) {
                ((ResourcePackExtension)resources).setFusionOverridesFolder(overridesFolder);
            }
        }
    }

    static {
        METADATA_SERIALIZER.func_110504_a((IMetadataSectionSerializer)FusionPackMetadataSection.INSTANCE, FusionPackMetadataSection.Data.class);
    }
}

