/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.vintagefix;

import com.google.common.collect.Lists;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.vintagefix.VintageFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TextureMap.class})
public class TextureAtlasMixinVintageFix {
    @Shadow
    @Final
    private Map<String, TextureAtlasSprite> field_110574_e;
    @Shadow
    @Final
    private Set<ResourceLocation> loadedSprites;
    @Shadow
    private int field_147636_j;

    @Shadow
    private ResourceLocation func_184396_a(TextureAtlasSprite sprite) {
        throw new AssertionError();
    }

    @Inject(method={"loadTextureAtlas(Lnet/minecraft/client/resources/IResourceManager;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;clear()V", ordinal=0, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void loadFusionSprites(IResourceManager resourceManager, CallbackInfo ci, int j, Stitcher stitcher) {
        FusionTextureMetadataSection.registerMetadata();
        ArrayList tasks = Lists.newArrayList();
        for (Map.Entry<String, TextureAtlasSprite> entry : this.field_110574_e.entrySet()) {
            tasks.add(CompletableFuture.runAsync(() -> {
                block40: {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)entry.getValue();
                    ResourceLocation location = this.func_184396_a(sprite);
                    try (IResource resource2 = resourceManager.func_110536_a(location);){
                        TextureAtlasSprite newTexture;
                        Pair<Integer, Integer> newSize;
                        Pair<TextureType<Object>, Object> metadata;
                        if (resource2 == null) break block40;
                        FusionTextureMetadataSection.Data data = (FusionTextureMetadataSection.Data)resource2.func_110526_a(FusionTextureMetadataSection.INSTANCE.func_110483_a());
                        Pair<TextureType<Object>, Object> pair = metadata = data == null ? null : data.pair;
                        if (metadata == null) break block40;
                        ResourceLocation identifier = new ResourceLocation(sprite.func_94215_i());
                        AnimationMetadataSection animation = (AnimationMetadataSection)resource2.func_110526_a("animation");
                        int originalWidth = sprite.field_130223_c;
                        int originalHeight = sprite.field_130224_d;
                        if (animation != null) {
                            if (animation.field_110476_b != -1 || animation.field_110477_c != -1) {
                                originalWidth = animation.field_110476_b == -1 ? animation.field_110476_b : sprite.field_130223_c;
                                originalHeight = animation.field_110477_c == -1 ? animation.field_110477_c : sprite.field_130224_d;
                            } else {
                                originalWidth = originalHeight = Math.min(sprite.field_130223_c, sprite.field_130224_d);
                            }
                        }
                        try {
                            newSize = metadata.left().getFrameSize(new SpritePreparationContextImpl(originalWidth, originalHeight, sprite.field_130223_c, sprite.field_130224_d, identifier, animation), metadata.right());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "' for texture '" + identifier + "'!", e);
                        }
                        if (newSize == null) {
                            throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "' for texture '" + identifier + "'!");
                        }
                        ((TextureAtlasSpriteExtension)sprite).setTextureSize(sprite.field_130223_c, sprite.field_130224_d);
                        sprite.field_130223_c = newSize.left();
                        sprite.field_130224_d = newSize.right();
                        if (sprite.field_110976_a.isEmpty()) {
                            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource2.func_110527_b());
                            ((TextureAtlasSpriteExtension)sprite).setTextureSize(bufferedImage.getWidth(), bufferedImage.getHeight());
                            int[][] pixels = new int[this.field_147636_j + 1][];
                            pixels[0] = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
                            bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), pixels[0], 0, bufferedImage.getWidth());
                            sprite.field_110976_a.add(pixels);
                        }
                        try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(sprite, (TextureMap)this);){
                            newTexture = metadata.left().createSprite(context, metadata.right());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Encountered an exception whilst initialising texture '" + identifier + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "'!", e);
                        }
                        if (newTexture == null) {
                            throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(metadata.left()) + "' for texture '" + identifier + "'!");
                        }
                        ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(metadata.left());
                        Stitcher stitcher2 = stitcher;
                        synchronized (stitcher2) {
                            stitcher.func_110934_a(newTexture);
                        }
                        this.loadedSprites.add(new ResourceLocation((String)entry.getKey()));
                    }
                    catch (FileNotFoundException resource2) {
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, VintageFix.WORKER_POOL));
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
    }
}

