/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;

public class MutableQuad {
    private static final int FULL_BRIGHT_LIGHTMAP = 0xF000F0;
    private int[] vertices;
    private VertexFormat vertexFormat;
    private int tintIndex;
    private EnumFacing lightFace;
    private TextureAtlasSprite sprite;
    private boolean shade;
    private boolean emissive = false;

    protected MutableQuad(int[] vertexData) {
        this.vertices = vertexData;
    }

    public MutableQuad() {
        this(new int[DefaultVertexFormats.field_176600_a.func_181719_f() * 4]);
    }

    public void fillFromBakedQuad(BakedQuad quad) {
        if (this.vertices.length < quad.func_178209_a().length) {
            this.vertices = new int[quad.func_178209_a().length];
        }
        System.arraycopy(quad.func_178209_a(), 0, this.vertices, 0, quad.func_178209_a().length);
        this.vertexFormat = quad.getFormat();
        this.tintIndex = quad.func_178211_c();
        this.lightFace = quad.func_178210_d();
        this.sprite = quad.func_187508_a();
        this.shade = quad.shouldApplyDiffuseLighting();
        this.emissive = false;
    }

    public void emissive(boolean emissive) {
        this.emissive = emissive;
    }

    public void lightmap(int vertexIndex, int lightmap) {
        if (!this.vertexFormat.func_177347_a(1)) {
            this.addVertexFormatElement(DefaultVertexFormats.field_181716_p);
        }
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_177344_b(1) / 4;
        this.vertices[offset] = lightmap;
    }

    public int lightmap(int vertexIndex) {
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_177344_b(1) / 4;
        return this.vertices[offset];
    }

    public void uv(int vertexIndex, float u, float v) {
        if (!this.vertexFormat.func_177347_a(0)) {
            this.addVertexFormatElement(DefaultVertexFormats.field_181715_o);
        }
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_177344_b(0) / 4;
        this.vertices[offset] = Float.floatToRawIntBits(u);
        this.vertices[offset + 1] = Float.floatToRawIntBits(v);
    }

    public float u(int vertexIndex) {
        if (!this.vertexFormat.func_177347_a(0)) {
            this.addVertexFormatElement(DefaultVertexFormats.field_181715_o);
        }
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_177344_b(0) / 4;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float v(int vertexIndex) {
        if (!this.vertexFormat.func_177347_a(0)) {
            this.addVertexFormatElement(DefaultVertexFormats.field_181715_o);
        }
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_177344_b(0) / 4 + 1;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public void pos(int vertexIndex, float x, float y, float z) {
        int elementIndex = this.vertexFormat.func_177343_g().indexOf(DefaultVertexFormats.field_181713_m);
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_181720_d(elementIndex) / 4;
        this.vertices[offset] = Float.floatToRawIntBits(x);
        this.vertices[offset + 1] = Float.floatToRawIntBits(y);
        this.vertices[offset + 2] = Float.floatToRawIntBits(z);
    }

    public float x(int vertexIndex) {
        int elementIndex = this.vertexFormat.func_177343_g().indexOf(DefaultVertexFormats.field_181713_m);
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_181720_d(elementIndex) / 4;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float y(int vertexIndex) {
        int elementIndex = this.vertexFormat.func_177343_g().indexOf(DefaultVertexFormats.field_181713_m);
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_181720_d(elementIndex) / 4 + 1;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public float z(int vertexIndex) {
        int elementIndex = this.vertexFormat.func_177343_g().indexOf(DefaultVertexFormats.field_181713_m);
        int offset = vertexIndex * this.vertexFormat.func_181719_f() + this.vertexFormat.func_181720_d(elementIndex) / 4 + 2;
        return Float.intBitsToFloat(this.vertices[offset]);
    }

    public BakedQuad toBakedQuad() {
        if (this.emissive) {
            for (int i = 0; i < 4; ++i) {
                this.lightmap(i, 0xF000F0);
            }
        }
        return new BakedQuad(Arrays.copyOf(this.vertices, this.vertexFormat.func_181719_f() * 4), this.tintIndex, this.lightFace, this.sprite, !this.emissive && this.shade, this.vertexFormat);
    }

    private void addVertexFormatElement(VertexFormatElement element) {
        VertexFormat newFormat = new VertexFormat(this.vertexFormat).func_181721_a(element);
        if (element.func_177368_f() % 4 != 0) {
            for (int i = 4 - element.func_177368_f() % 4; i > 0; --i) {
                newFormat = newFormat.func_181721_a(DefaultVertexFormats.field_181718_r);
            }
        }
        int[] arr = new int[Math.max(newFormat.func_181719_f() * 4, this.vertices.length)];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.vertices, this.vertexFormat.func_181719_f() * i, arr, newFormat.func_181719_f() * i, this.vertexFormat.func_181719_f());
        }
        this.vertices = arr;
        this.vertexFormat = newFormat;
    }
}

