/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.ResourcePackExtension;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockModelModifierReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<ModelResourceLocation, Properties> models = new HashMap<ModelResourceLocation, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public List<ModelResourceLocation> registerOverlays() {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        return models.stream().map(BlockModelModifierReloadListener::overlayModelLocation).collect(Collectors.toList());
    }

    public void applyOverlays(ModelBakery bakery) {
        RegistrySimple bakedModels = bakery.field_177605_n;
        for (Map.Entry<ModelResourceLocation, Properties> entry : this.models.entrySet()) {
            ModelResourceLocation target = entry.getKey();
            IBakedModel targetModel = (IBakedModel)bakedModels.func_82594_a((Object)target);
            Properties properties = entry.getValue();
            List<ResourceLocation> overlays = properties.appendModels;
            List<IBakedModel> overlayModels = overlays.stream().map(BlockModelModifierReloadListener::overlayModelLocation).map(arg_0 -> ((RegistrySimple)bakedModels).func_82594_a(arg_0)).collect(Collectors.toList());
            IBakedModel model = new BlockModelModifierBakedModel(targetModel, overlayModels);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel(model);
            }
            bakedModels.func_82595_a((Object)target, (Object)model);
        }
    }

    private static ModelResourceLocation overlayModelLocation(ResourceLocation modelLocation) {
        return new ModelResourceLocation(modelLocation, "fusion_overlay_model");
    }

    public void reload(IResourceManager resourceManager) {
        ResourceLocation location;
        this.models.clear();
        HashMap<ResourceLocation, JsonElement> resources = new HashMap<ResourceLocation, JsonElement>();
        for (ResourceLocation resourceLocation : BlockModelModifierReloadListener.listResources(resourceManager, LOCATION, s -> s.endsWith(".json"))) {
            location = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(LOCATION.length() + 1, resourceLocation.func_110623_a().length() - ".json".length()));
            try {
                IResource resource = resourceManager.func_110536_a(resourceLocation);
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
                    JsonElement element = (JsonElement)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                    resources.put(location, element);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse json from block model overlay '{}'!", (Object)resourceLocation, (Object)e);
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading block model overlay at '{}'!", (Object)resourceLocation, (Object)e);
            }
        }
        for (Map.Entry entry : resources.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + location + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        BlockStateMapper blockStateMapper = Minecraft.func_71410_x().field_175617_aL.func_174954_c().func_178120_a();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                ResourceLocation identifier = new ResourceLocation(element.getAsString());
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(identifier);
                if (block == null || block == Blocks.field_150350_a) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
                }
                block.func_176194_O().func_177619_a().stream().map(state -> (ModelResourceLocation)blockStateMapper.func_188181_b(state.func_177230_c()).get(state)).forEach(targets::add);
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).map(state -> (ModelResourceLocation)blockStateMapper.func_188181_b(state.func_177230_c()).get(state)).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<ResourceLocation> models = new LinkedHashSet<ResourceLocation>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(new ResourceLocation(element.getAsString()));
            }
        }
        boolean paneCullingFix = false;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && !paneCullingFix) {
            return;
        }
        for (ModelResourceLocation target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<IBlockState> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(identifier);
        if (block == null || block == Blocks.field_150350_a) {
            throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
        }
        HashMap<IProperty, ImmutableSet> properties = new HashMap<IProperty, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").size() == 0) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            IProperty property = block.func_176194_O().func_185920_a((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.func_185929_b(((JsonElement)entry.getValue()).getAsString()).toJavaUtil();
                if (!value.isPresent()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().size() == 0) {
                    throw new JsonParseException("Valid values for property '" + property.func_177701_a() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.func_185929_b(element.getAsString()).toJavaUtil();
                    if (!value.isPresent()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of(block.func_176194_O().func_177621_b());
        for (IProperty property : block.func_176194_O().func_177623_d()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.func_177700_c().stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
        }
        return states;
    }

    private static <T extends Comparable<T>> IBlockState stateWithValue(IBlockState state, IProperty<?> property, Object value) {
        return state.func_177226_a(property, (Comparable)value);
    }

    public static Collection<ResourceLocation> listResources(IResourceManager resourceManager, String folder, Predicate<String> predicate) {
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            HashSet resources = Sets.newHashSet();
            for (FallbackResourceManager domainManager : ((SimpleReloadableResourceManager)resourceManager).field_110548_a.values()) {
                resources.addAll(BlockModelModifierReloadListener.listResources((IResourceManager)domainManager, folder, predicate));
            }
            ArrayList list = Lists.newArrayList((Iterable)resources);
            Collections.sort(list);
            return list;
        }
        if (resourceManager instanceof FallbackResourceManager) {
            ArrayList resources = Lists.newArrayList();
            for (IResourcePack pack : ((FallbackResourceManager)resourceManager).field_110540_a) {
                if (!(pack instanceof ResourcePackExtension)) continue;
                resources.addAll(((ResourcePackExtension)pack).fusionGetResources(folder, Integer.MAX_VALUE, predicate));
            }
            Collections.sort(resources);
            return resources;
        }
        return Collections.emptyList();
    }

    private static class Properties {
        final List<ResourceLocation> appendModels = new ArrayList<ResourceLocation>();
        boolean paneCullingFix;

        private Properties() {
        }
    }
}

