/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierReloadListener;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemModelModifierReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/items";
    public static final ItemModelModifierReloadListener INSTANCE = new ItemModelModifierReloadListener();
    private final Map<ModelResourceLocation, ItemModelPredicatesProperties> models = new HashMap<ModelResourceLocation, ItemModelPredicatesProperties>();

    private ItemModelModifierReloadListener() {
    }

    public List<ModelResourceLocation> registerPredicateModels() {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (ItemModelPredicatesProperties properties : this.models.values()) {
            models.addAll(properties.dependencies());
        }
        return models.stream().map(ItemModelModifierReloadListener::predicateModelLocation).collect(Collectors.toList());
    }

    public void applyPredicateModels(ModelBakery bakery) {
        RegistrySimple bakedModels = bakery.field_177605_n;
        for (Map.Entry<ModelResourceLocation, ItemModelPredicatesProperties> entry : this.models.entrySet()) {
            ModelResourceLocation target = entry.getKey();
            ItemModelPredicatesProperties properties = entry.getValue();
            IBakedModel defaultModel = properties.defaultModel == null ? (IBakedModel)bakedModels.func_82594_a((Object)target) : (IBakedModel)bakedModels.func_82594_a((Object)ItemModelModifierReloadListener.predicateModelLocation(properties.defaultModel));
            List<Pair<ItemPredicate, IBakedModel>> models = properties.models.stream().map(pair -> pair.mapRight(ItemModelModifierReloadListener::predicateModelLocation).mapRight(arg_0 -> ((RegistrySimple)bakedModels).func_82594_a(arg_0))).collect(Collectors.toList());
            bakedModels.func_82595_a((Object)target, (Object)new ItemModelModifierBakedModel(defaultModel, models));
        }
    }

    private static ModelResourceLocation predicateModelLocation(ResourceLocation modelLocation) {
        return new ModelResourceLocation(modelLocation, "fusion_predicate_model");
    }

    public void reload(IResourceManager resourceManager) {
        ResourceLocation location;
        ItemPredicateRegistry.finalizeRegistration();
        this.models.clear();
        HashMap<ResourceLocation, JsonElement> resources = new HashMap<ResourceLocation, JsonElement>();
        for (ResourceLocation resourceLocation : BlockModelModifierReloadListener.listResources(resourceManager, LOCATION, s -> s.endsWith(".json"))) {
            location = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(LOCATION.length() + 1, resourceLocation.func_110623_a().length() - ".json".length()));
            try {
                IResource resource = resourceManager.func_110536_a(resourceLocation);
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
                    JsonElement element = (JsonElement)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                    resources.put(location, element);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse json from item model predicates file '{}'!", (Object)resourceLocation, (Object)e);
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading item model predicates file at '{}'!", (Object)resourceLocation, (Object)e);
            }
        }
        for (Map.Entry entry : resources.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Item model predicates file '" + location + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse item model predicates file '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet<ModelResourceLocation> targets = new HashSet<ModelResourceLocation>();
        for (JsonElement element : targetsJson) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Array property 'targets' must only contain strings!");
            }
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
            }
            ResourceLocation identifier = new ResourceLocation(element.getAsString());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(identifier);
            if (item == null || item == Items.field_190931_a) {
                throw new JsonParseException("Could not find an item for target '" + identifier + "'!");
            }
            targets.add(new ModelResourceLocation(identifier, "inventory"));
        }
        if (targets.isEmpty()) {
            return;
        }
        ResourceLocation defaultModel = null;
        if (json.has("default_model")) {
            if (!json.get("default_model").isJsonPrimitive() || !json.getAsJsonPrimitive("default_model").isString()) {
                throw new JsonParseException("Property 'default_model' must be a string!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("default_model").getAsString())) {
                throw new JsonParseException("Default model must be a valid identifier, not '" + json.get("default_model").getAsString() + "'!");
            }
            defaultModel = new ResourceLocation(json.get("default_model").getAsString());
        }
        if (!json.has("models") || !json.get("models").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'models'!");
        }
        JsonArray modelsJson = json.getAsJsonArray("models");
        ArrayList<Pair<ItemPredicate, ResourceLocation>> models = new ArrayList<Pair<ItemPredicate, ResourceLocation>>();
        for (JsonElement element : modelsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Array property 'models' must only contain objects!");
            }
            models.add(this.parseModelEntry(element.getAsJsonObject()));
        }
        if (defaultModel == null && models.isEmpty()) {
            return;
        }
        ItemModelPredicatesProperties properties = new ItemModelPredicatesProperties(defaultModel, models);
        for (ModelResourceLocation target : targets) {
            this.models.put(target, properties);
        }
    }

    private Pair<ItemPredicate, ResourceLocation> parseModelEntry(JsonObject json) {
        if (!(json.has("model") && json.get("model").isJsonPrimitive() && json.getAsJsonPrimitive("model").isString())) {
            throw new JsonParseException("Models entry must have string property 'model'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("model").getAsString())) {
            throw new JsonParseException("Model must be a valid identifier, not '" + json.get("model").getAsString() + "'!");
        }
        ResourceLocation model = new ResourceLocation(json.get("model").getAsString());
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new JsonParseException("Models entry must have array property 'conditions'!");
        }
        JsonArray conditionsJson = json.getAsJsonArray("conditions");
        if (conditionsJson.size() == 0) {
            throw new JsonParseException("Model entry property 'conditions' must not be empty!");
        }
        ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
        for (JsonElement element : conditionsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Model entry property 'conditions' must only contain objects!");
            }
            predicates.add(ItemPredicateRegistry.deserializeItemPredicate(element.getAsJsonObject()));
        }
        ItemPredicate predicate = predicates.size() == 1 ? (ItemPredicate)predicates.get(0) : new AndItemPredicate(predicates);
        return Pair.of(predicate, model);
    }

    private static class ItemModelPredicatesProperties {
        final ResourceLocation defaultModel;
        final List<Pair<ItemPredicate, ResourceLocation>> models;

        private ItemModelPredicatesProperties(ResourceLocation defaultModel, List<Pair<ItemPredicate, ResourceLocation>> models) {
            this.defaultModel = defaultModel;
            this.models = models;
        }

        Collection<ResourceLocation> dependencies() {
            HashSet<ResourceLocation> models = new HashSet<ResourceLocation>(this.models.size() + 1);
            if (this.defaultModel != null) {
                models.add(this.defaultModel);
            }
            for (Pair<ItemPredicate, ResourceLocation> entry : this.models) {
                models.add(entry.right());
            }
            return models;
        }
    }
}

