/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelType;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, BaseModelData data) {
        VanillaModelType.resolveParents(context, data.getVanillaModel());
        ((BaseModelDataImpl)data).validateParents(context::getModel, null);
        return ((BaseModelDataImpl)data).gatherTextures(context);
    }

    @Override
    @Nullable
    public ModelBlock getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<ResourceLocation> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public IBakedModel bake(ModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context::getModel, context.getModelIdentifier());
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178322_i, true);
        boolean gui3d = ((BaseModelDataImpl)data).model.func_178311_c();
        TextureAtlasSprite particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        ItemTransformVec3f transformThirdPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformThirdPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFirstPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFirstPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformHead = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.HEAD) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.HEAD) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformGui = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.GUI) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.GUI) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformGround = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.GROUND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.GROUND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFixed = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIXED) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIXED) : null, ItemTransformVec3f.field_178366_a);
        ItemCameraTransforms itemTransforms = new ItemCameraTransforms(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        ItemOverrideList itemOverrides = data.getVanillaModel().field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(data.getVanillaModel().field_187968_k);
        return new BaseBakedModel(quads, ambientOcclusion, gui3d, particleSprite, itemTransforms, itemOverrides);
    }

    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        ModelBlock model = (ModelBlock)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<Object> parents = Collections.emptyList();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = Collections.singletonList(new ResourceLocation(parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList(parentArray.size());
            for (JsonElement element : parentArray) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(new ResourceLocation(parent));
            }
            if (!parents.isEmpty()) {
                model.field_178316_e = (ResourceLocation)parents.get(0);
            }
        }
        ArrayList<BaseModelElement> elements = new ArrayList<BaseModelElement>(model.field_178314_g.size());
        JsonArray elementsJson = json.getAsJsonArray("elements");
        for (int i = 0; i < model.field_178314_g.size(); ++i) {
            BlockPart vanillaElement = (BlockPart)model.field_178314_g.get(i);
            Integer lightEmission = null;
            JsonElement lightEmissionJson = elementsJson.get(i).getAsJsonObject().get("light_emission");
            if (lightEmissionJson != null) {
                if (!lightEmissionJson.isJsonPrimitive() || !lightEmissionJson.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("Element property 'light_emission' must be a number!");
                }
                lightEmission = lightEmissionJson.getAsInt();
                if (lightEmission < 0 || lightEmission > 15) {
                    throw new JsonParseException("Element property 'light_emission' must be between 0 and 15!");
                }
            }
            elements.add(new BaseModelElement(vanillaElement.field_178241_a, vanillaElement.field_178239_b, vanillaElement.field_178240_c, vanillaElement.field_178237_d, vanillaElement.field_178238_e, lightEmission));
        }
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray();
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        for (int i = 0; i < ((BaseModelDataImpl)value).getElements().size(); ++i) {
            Integer lightEmission = ((BaseModelDataImpl)value).getElements().get((int)i).light_emission;
            if (lightEmission == null) continue;
            json.getAsJsonArray("elements").get(i).getAsJsonObject().addProperty("light_emission", (Number)lightEmission);
        }
        return json;
    }
}

