/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.util.Serializer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class NotConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<NotConnectionPredicate> SERIALIZER = new Serializer<NotConnectionPredicate>(){

        @Override
        public NotConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicate") || !json.get("predicate").isJsonObject()) {
                throw new JsonParseException("Not-predicate must have object property 'predicate'!");
            }
            ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(json.getAsJsonObject("predicate"));
            return new NotConnectionPredicate(predicate);
        }

        @Override
        public JsonObject serialize(NotConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.add("predicates", (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(value.predicate));
            return json;
        }
    };
    private final ConnectionPredicate predicate;

    public <T extends ConnectionPredicate> NotConnectionPredicate(T predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean shouldConnect(EnumFacing side, @Nullable IBlockState ownState, IBlockState otherState, IBlockState blockInFront, ConnectionDirection direction) {
        return !this.predicate.shouldConnect(side, ownState, otherState, blockInFront, direction);
    }

    @Override
    public boolean shouldConnect(IBlockAccess level, BlockPos pos, EnumFacing side, @Nullable IBlockState ownState, IBlockState otherState, IBlockState blockInFront, ConnectionDirection direction) {
        return !this.predicate.shouldConnect(level, pos, side, ownState, otherState, blockInFront, direction);
    }

    @Override
    public boolean isSensitive() {
        return this.predicate.isSensitive();
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotConnectionPredicate)) {
            return false;
        }
        NotConnectionPredicate that = (NotConnectionPredicate)o;
        return this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }
}

