/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MinimumVersionWarningScreen
extends GuiScreen {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon.png");
    private final ResourcePackRepository.Entry pack;
    private final Consumer<Boolean> confirmation;
    private final String title;
    private final int titleWidth;
    private final String packName;
    private final List<String> packDescription;
    private final List<String> headerMessage;
    private final List<String> confirmationMessage;
    private final int headerMessageWidth;
    private final int confirmationMessageWidth;
    private final String currentVersionLabel;
    private final String requiredVersionLabel;
    private final String currentVersion;
    private final String requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final GuiOptionButton confirmButton;
    private final GuiOptionButton cancelButton;

    public MinimumVersionWarningScreen(ResourcePackRepository.Entry pack, Consumer<Boolean> confirmation) {
        this.pack = pack;
        this.confirmation = confirmation;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.title = new TextComponentTranslation("fusion.resource_packs.warning_screen.title", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.UNDERLINE)).func_150254_d();
        this.titleWidth = font.func_78256_a(this.title);
        String title = pack.func_110515_d();
        int width = font.func_78256_a(title);
        if (width > 157) {
            title = font.func_78269_a(title, 157 - font.func_78256_a("...")) + "...";
        }
        this.packName = title;
        List lines = font.func_78271_c(pack.func_110519_e(), 157);
        this.packDescription = lines.size() > 2 ? lines.subList(0, 2) : lines;
        this.headerMessage = font.func_78271_c(new TextComponentTranslation("fusion.resource_packs.warning_screen.message", new Object[0]).func_150254_d(), 220);
        this.headerMessageWidth = this.headerMessage.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0);
        this.confirmationMessage = font.func_78271_c(new TextComponentTranslation("fusion.resource_packs.warning_screen.confirmation", new Object[0]).func_150254_d(), 220);
        this.confirmationMessageWidth = this.confirmationMessage.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0);
        this.currentVersionLabel = new TextComponentTranslation("fusion.resource_packs.warning_screen.current_version", new Object[0]).func_150254_d();
        this.requiredVersionLabel = new TextComponentTranslation("fusion.resource_packs.warning_screen.required_version", new Object[0]).func_150254_d();
        this.versionLabelTextWidth = Math.max(font.func_78256_a(this.currentVersionLabel), font.func_78256_a(this.requiredVersionLabel));
        this.currentVersion = new TextComponentString(FusionClient.getFusionVersion()).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150254_d();
        this.requiredVersion = new TextComponentString(((PackExtension)pack).getFusionMetadata().getMinimumVersion()).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150254_d();
        this.versionTextWidth = Math.max(font.func_78256_a(this.currentVersion), font.func_78256_a(this.requiredVersion));
        this.confirmButton = new GuiOptionButton(0, 80, 20, new TextComponentTranslation("fusion.resource_packs.warning_screen.confirm", new Object[0]).func_150254_d());
        this.cancelButton = new GuiOptionButton(1, 80, 20, new TextComponentTranslation("fusion.resource_packs.warning_screen.cancel", new Object[0]).func_150254_d());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.confirmButton.field_146128_h = this.field_146294_l / 2 - this.confirmButton.field_146120_f - 2;
        this.confirmButton.field_146129_i = this.field_146295_m / 2 + 110 - this.confirmButton.field_146121_g;
        this.cancelButton.field_146128_h = this.field_146294_l / 2 + 2;
        this.cancelButton.field_146129_i = this.field_146295_m / 2 + 110 - this.cancelButton.field_146121_g;
        this.func_189646_b((GuiButton)this.confirmButton);
        this.func_189646_b((GuiButton)this.cancelButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.confirmButton) {
            this.confirmation.accept(true);
        } else if (button == this.cancelButton) {
            this.confirmation.accept(false);
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.field_146294_l / 2.0f), (float)((float)this.field_146295_m / 2.0f - 110.0f), (float)0.0f);
        int titleLeft = -(this.titleWidth + 17) / 2;
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FUSION_LOGO);
        Gui.func_146110_a((int)titleLeft, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (float)12.0f, (float)12.0f);
        GlStateManager.func_179084_k();
        this.func_73731_b(this.field_146289_q, this.title, titleLeft + 17, 2, -1);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        int middleHeight = 98 + this.headerMessage.size() * 10 + this.confirmationMessage.size() * 10;
        GlStateManager.func_179109_b((float)((float)this.field_146294_l / 2.0f), (float)((float)(this.field_146295_m - middleHeight) / 2.0f), (float)0.0f);
        Gui.func_73734_a((int)-98, (int)0, (int)98, (int)36, (int)0x46FFFFFF);
        this.pack.func_110518_a(Minecraft.func_71410_x().func_110434_K());
        Gui.func_146110_a((int)-96, (int)2, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        this.field_146289_q.func_175063_a(this.packName, -62.0f, 3.0f, 0xFFFFFF);
        for (int i = 0; i < this.packDescription.size(); ++i) {
            this.func_73731_b(this.field_146289_q, this.packDescription.get(i), -62, 14 + i * 10, -8355712);
        }
        this.func_73730_a(-115, 115, 44, -1);
        int textLeft = -Math.max(this.headerMessageWidth, this.confirmationMessageWidth) / 2;
        for (int i = 0; i < this.headerMessage.size(); ++i) {
            this.func_73731_b(this.field_146289_q, this.headerMessage.get(i), textLeft, 54 + i * 10, -1);
        }
        int textHeight = this.headerMessage.size() * 10;
        for (int i = 0; i < this.confirmationMessage.size(); ++i) {
            this.func_73731_b(this.field_146289_q, this.confirmationMessage.get(i), textLeft, 58 + textHeight + i * 10, -1);
        }
        this.func_73730_a(-115, 115, 66 + (textHeight += this.confirmationMessage.size() * 10), -1);
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        this.func_73731_b(this.field_146289_q, this.currentVersionLabel, textLeft, 76 + textHeight, -4934476);
        this.func_73731_b(this.field_146289_q, this.requiredVersionLabel, textLeft, 88 + textHeight, -4934476);
        this.func_73731_b(this.field_146289_q, this.currentVersion, textLeft + this.versionLabelTextWidth + 5, 76 + textHeight, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.requiredVersion, textLeft + this.versionLabelTextWidth + 5, 88 + textHeight, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.confirmation.accept(false);
            return;
        }
        super.func_73869_a(c, keyCode);
    }
}

