/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class SpriteCreationContextImpl
implements SpriteCreationContext,
AutoCloseable {
    private final TextureAtlasSprite original;
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation identifier;
    private final List<int[][]> images;
    private final int atlasWidth;
    private final int atlasHeight;
    private final TextureMap atlas;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final int mipmapLevels;
    private boolean imagesRequested = false;

    public SpriteCreationContextImpl(TextureAtlasSprite original, TextureMap atlas) {
        this.original = original;
        Pair<Integer, Integer> textureSize = ((TextureAtlasSpriteExtension)original).getTextureSize();
        this.textureWidth = textureSize.left();
        this.textureHeight = textureSize.right();
        this.identifier = new ResourceLocation(original.func_94215_i());
        this.images = original.field_110976_a;
        this.atlasWidth = Math.round((float)(original.field_110975_c + original.field_130223_c) / original.field_110980_m);
        this.atlasHeight = Math.round((float)(original.field_110974_d + original.field_130224_d) / original.field_110978_o);
        this.atlas = atlas;
        this.spriteX = original.field_110975_c;
        this.spriteY = original.field_110974_d;
        this.spriteWidth = original.field_130223_c;
        this.spriteHeight = original.field_130224_d;
        this.mipmapLevels = original.field_110976_a.size() - 1;
    }

    private void closeUnusedResources() {
        if (!this.imagesRequested) {
            this.original.func_130103_l();
        }
    }

    @Override
    public TextureAtlasSprite createOriginalSprite() {
        this.imagesRequested = true;
        return this.original;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public ResourceLocation getTextureIdentifier() {
        return this.identifier;
    }

    @Override
    public List<int[][]> getTextureBuffers() {
        this.imagesRequested = true;
        return this.images;
    }

    @Override
    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    @Override
    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    @Override
    public TextureMap getAtlas() {
        return this.atlas;
    }

    @Override
    public int getSpritePositionX() {
        return this.spriteX;
    }

    @Override
    public int getSpritePositionY() {
        return this.spriteY;
    }

    @Override
    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    @Override
    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    @Override
    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    @Override
    public void close() {
        this.closeUnusedResources();
    }
}

