/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ConnectingTextureSprite
extends BaseTextureSprite {
    private final int originalWidth;
    private final int originalHeight;
    private float startU;
    private float startV;
    private boolean rotatedImage;

    protected ConnectingTextureSprite(TextureAtlasSprite original, ConnectingTextureData data) {
        super(original, data);
        this.originalWidth = this.field_130223_c;
        this.originalHeight = this.field_130224_d;
        this.resizeUV();
    }

    public float getStartU() {
        return this.startU;
    }

    public float getStartV() {
        return this.startV;
    }

    @Override
    public ConnectingTextureData data() {
        return (ConnectingTextureData)super.data();
    }

    public void func_110971_a(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {
        super.func_110971_a(inX, inY, originInX, originInY, rotatedIn);
        this.startU = this.field_110979_l;
        this.startV = this.field_110977_n;
        this.resizeUV();
        if (this.field_130222_e && !this.rotatedImage) {
            this.rotateLayout();
        }
    }

    private void resizeUV() {
        ConnectingTextureLayoutHandler layoutHandler = ConnectingTextureLayoutHandler.get(this.data().getLayout());
        int layoutWidth = layoutHandler.getWidth();
        int layoutHeight = layoutHandler.getHeight();
        if (this.field_130222_e) {
            int width = layoutWidth;
            layoutWidth = layoutHeight;
            layoutHeight = width;
        }
        float tileWidth = (this.field_110980_m - this.field_110979_l) / (float)layoutWidth;
        float tileHeight = (this.field_110978_o - this.field_110977_n) / (float)layoutHeight;
        this.field_110980_m = this.field_110979_l + tileWidth * (float)(layoutHandler.defaultTileX() + 1);
        this.field_110978_o = this.field_110977_n + tileHeight * (float)(layoutHandler.defaultTileY() + 1);
        this.field_110979_l += tileWidth * (float)layoutHandler.defaultTileX();
        this.field_110977_n += tileHeight * (float)layoutHandler.defaultTileY();
    }

    public void rotateLayout() {
        for (int frame = 0; frame < this.field_110976_a.size(); ++frame) {
            int[][] pixelsPerLevel = (int[][])this.field_110976_a.get(frame);
            ConnectingTextureLayoutHandler layoutHandler = ConnectingTextureLayoutHandler.get(this.data().getLayout());
            int layoutWidth = layoutHandler.getWidth();
            int layoutHeight = layoutHandler.getHeight();
            int textureWidth = this.originalWidth;
            int textureHeight = this.originalHeight;
            int tileWidth = textureWidth / layoutWidth;
            int tileHeight = textureHeight / layoutHeight;
            int[] rotatedPixels = new int[textureWidth * textureHeight];
            for (int tileX = 0; tileX < layoutWidth; ++tileX) {
                for (int tileY = 0; tileY < layoutHeight; ++tileY) {
                    for (int line = 0; line < tileHeight; ++line) {
                        System.arraycopy(pixelsPerLevel[0], textureWidth * (tileY * tileHeight + line) + tileX * tileWidth, rotatedPixels, textureHeight * (tileX * tileHeight + line) + tileY * tileWidth, tileWidth);
                    }
                }
            }
            pixelsPerLevel[0] = rotatedPixels;
            this.field_110976_a.set(frame, pixelsPerLevel);
        }
        try {
            this.func_147963_d(((int[][])this.field_110976_a.get(0)).length - 1);
        }
        catch (Exception e) {
            FusionClient.LOGGER.error("Encountered an exception whilst generating mipmaps for rotated connecting texture:", (Throwable)e);
        }
        this.field_130223_c = this.originalHeight;
        this.field_130224_d = this.originalWidth;
        this.rotatedImage = true;
    }
}

