/*
 * Decompiled with CFR 0.152.
 */
package dev.greendata.dimensionlocker.containers;

import dev.greendata.dimensionlocker.configs.LockableDimension;
import dev.greendata.dimensionlocker.configs.LockableDimensionsConfig;
import dev.greendata.dimensionlocker.configs.LockableDimensionsConfigManager;
import dev.greendata.dimensionlocker.managers.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class LockWorldContainer
extends class_1707 {
    private final class_1263 containerInventory;
    private final MinecraftServer server;
    private static LockableDimensionsConfig config;

    public LockWorldContainer(int syncId, class_1661 playerInventory, MinecraftServer server) {
        super(class_3917.field_17326, syncId, playerInventory, (class_1263)new class_1277(27), 3);
        ArrayList<LockableDimension> defaultDimensions = new ArrayList<LockableDimension>();
        defaultDimensions.add(new LockableDimension("minecraft:overworld", "Overworld", "dim_overworld", "dim_overworld_locked"));
        defaultDimensions.add(new LockableDimension("minecraft:the_nether", "The Nether", "dim_the_nether", "dim_the_nether_locked"));
        defaultDimensions.add(new LockableDimension("minecraft:the_end", "The End", "dim_the_end", "dim_the_end_locked"));
        LockableDimensionsConfigManager manager = new LockableDimensionsConfigManager(new LockableDimensionsConfig(defaultDimensions));
        config = (LockableDimensionsConfig)manager.load();
        this.containerInventory = this.method_7629();
        this.server = server;
        this.field_7761.clear();
        this.method_7621(new ReadOnlySlot(this.containerInventory, 0));
        this.method_7621(new ReadOnlySlot(this.containerInventory, 1));
        this.method_7621(new ReadOnlySlot(this.containerInventory, 2));
        this.updateSlotItem();
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex >= 0 && slotIndex < this.containerInventory.method_5439()) {
            for (int i = 0; i < LockWorldContainer.config.dimensions.size(); ++i) {
                boolean isDimensionLocked;
                if (slotIndex != i) continue;
                Connection connection = DatabaseManager.getConnection();
                String query = "SELECT identity FROM locked_dimensions WHERE identity = ?;\n";
                try (PreparedStatement stmt = connection.prepareStatement(query);){
                    stmt.setString(1, LockWorldContainer.config.dimensions.get((int)i).dimensionIdentifier);
                    ResultSet result = stmt.executeQuery();
                    isDimensionLocked = result.getString("identity") != null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                if (isDimensionLocked) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("unlocked dimension " + LockWorldContainer.config.dimensions.get((int)i).displayName + "!")), true);
                    command = "    DELETE FROM locked_dimensions WHERE identity = ?;\n";
                    try (PreparedStatement stmt = connection.prepareStatement(command);){
                        stmt.setString(1, LockWorldContainer.config.dimensions.get((int)i).dimensionIdentifier);
                        int rowsAffected = stmt.executeUpdate();
                        if (rowsAffected > 0) {
                            player.method_7353((class_2561)class_2561.method_43470((String)("unlocked dimension " + LockWorldContainer.config.dimensions.get((int)i).displayName + "!")), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43470((String)("Could not find dimension " + LockWorldContainer.config.dimensions.get((int)i).displayName + "!")), true);
                        }
                    }
                    catch (SQLException e) {
                        player.method_7353((class_2561)class_2561.method_43470((String)("failed unlocking the dimension " + LockWorldContainer.config.dimensions.get((int)i).displayName + "!")), true);
                        e.printStackTrace();
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("locked dimension " + LockWorldContainer.config.dimensions.get((int)i).displayName + "!")), true);
                    command = "INSERT INTO locked_dimensions (identity) VALUES (?);\n";
                    try (PreparedStatement stmt = connection.prepareStatement(command);){
                        stmt.setString(1, LockWorldContainer.config.dimensions.get((int)i).dimensionIdentifier);
                        stmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                this.updateSlotItem();
                return;
            }
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void updateSlotItem() {
        Connection connection = DatabaseManager.getConnection();
        String query = "SELECT identity FROM locked_dimensions;\n";
        ArrayList<String> entries = new ArrayList<String>();
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                entries.add(rs.getString("identity"));
            }
        }
        catch (SQLException e) {
            return;
        }
        for (int i = 0; i < LockWorldContainer.config.dimensions.size(); ++i) {
            if (entries.contains(LockWorldContainer.config.dimensions.get((int)i).dimensionIdentifier)) {
                this.containerInventory.method_5447(i, this.getDimensionItem(LockWorldContainer.config.dimensions.get((int)i).displayName, LockWorldContainer.config.dimensions.get((int)i).lockedCustomModelString, true));
                continue;
            }
            this.containerInventory.method_5447(i, this.getDimensionItem(LockWorldContainer.config.dimensions.get((int)i).displayName, LockWorldContainer.config.dimensions.get((int)i).unlockedCustomModelString, false));
        }
    }

    private class_1799 getDimensionItem(String name, String customModelDataString, Boolean isLocked) {
        class_1799 itemTemplate = new class_1799((class_1935)(isLocked != false ? class_1802.field_19058 : class_1802.field_19049), 1);
        ArrayList<String> customModels = new ArrayList<String>();
        customModels.add(customModelDataString);
        class_9280 t = new class_9280(new ArrayList(), new ArrayList(), customModels, new ArrayList());
        itemTemplate.method_57379(class_9334.field_49637, (Object)t);
        itemTemplate.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
        return itemTemplate;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public static class ReadOnlySlot
    extends class_1735 {
        public ReadOnlySlot(class_1263 inventory, int index) {
            super(inventory, index, 0, 0);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }
    }
}

