/*
 * Decompiled with CFR 0.152.
 */
package dev.greendata.dimensionlocker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.greendata.dimensionlocker.containers.LockWorldContainer;
import dev.greendata.dimensionlocker.managers.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;

public class ModCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ModCommands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dimension").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            Connection connection = DatabaseManager.getConnection();
            String query = "SELECT identity FROM locked_dimensions;\n";
            try (Statement stmt = connection.createStatement();
                 ResultSet rs = stmt.executeQuery(query);){
                ArrayList<String> entries = new ArrayList<String>();
                while (rs.next()) {
                    entries.add(rs.getString("identity"));
                }
                if (!entries.isEmpty()) {
                    ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Locked Dimensions: " + String.join((CharSequence)", ", entries));
                } else {
                    ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "There are no locked dimensions!");
                }
            }
            catch (SQLException e) {
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Failed to get locked dimensions!");
                e.printStackTrace();
            }
            return 1;
        }))).then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> {
            class_3218 world = class_2181.method_9289((CommandContext)ctx, (String)"dimension");
            class_2960 id = world.method_27983().method_29177();
            Connection connection = DatabaseManager.getConnection();
            String command = "INSERT INTO locked_dimensions (identity) VALUES (?);\n";
            try (PreparedStatement stmt = connection.prepareStatement(command);){
                stmt.setString(1, id.toString());
                stmt.executeUpdate();
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Locked dimension: " + String.valueOf(id), true);
            }
            catch (SQLException e) {
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Failed to lock dimension: " + String.valueOf(id), false);
                e.printStackTrace();
            }
            return 1;
        })))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> {
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            class_3218 world = class_2181.method_9289((CommandContext)ctx, (String)"dimension");
            class_2960 id = world.method_27983().method_29177();
            Connection connection = DatabaseManager.getConnection();
            String command = "    DELETE FROM locked_dimensions WHERE identity = ?;\n";
            try (PreparedStatement stmt = connection.prepareStatement(command);){
                stmt.setString(1, id.toString());
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected > 0) {
                    ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Unlocked dimension: " + String.valueOf(id), true);
                } else {
                    ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Dimension " + String.valueOf(id) + " not found!", false);
                }
            }
            catch (SQLException e) {
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Failed to lock dimension: " + String.valueOf(id), false);
                e.printStackTrace();
            }
            return 1;
        })))).then(class_2170.method_9247((String)"unlock-all").executes(ctx -> {
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Unlocked all dimensions", true);
            Connection connection = DatabaseManager.getConnection();
            String command = "    DELETE FROM locked_dimensions;\n";
            try (PreparedStatement stmt = connection.prepareStatement(command);){
                stmt.executeUpdate();
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Successfully cleared all locked dimensions.", true);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ModCommands.SendFeedback((CommandContext<class_2168>)ctx, "Failed to clear locked dimensions.", false);
            }
            return 1;
        }))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_44023().method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return class_2561.method_43470((String)"Server Menu");
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new LockWorldContainer(syncId, inv, ((class_2168)ctx.getSource()).method_9211());
                }
            });
            return 1;
        }));
    }

    private static void SendFeedback(CommandContext<class_2168> ctx, String message) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)message), false);
    }

    private static void SendFeedback(CommandContext<class_2168> ctx, String message, boolean broadcastToOps) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)message), broadcastToOps);
    }
}

