/*
 * Decompiled with CFR 0.152.
 */
package dev.greendata.dimensionlocker.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class ConfigManager<T> {
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final File file;
    protected final Codec<T> codec;
    protected final T defaultConfig;

    protected ConfigManager(File file, Codec<T> codec, T defaultConfig) {
        this.file = file;
        this.codec = codec;
        this.defaultConfig = defaultConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T load() {
        if (!this.file.exists()) {
            this.save(this.defaultConfig);
            return this.defaultConfig;
        }
        try (FileReader reader = new FileReader(this.file);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            Object object = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseGet(() -> {
                System.err.println("Failed to parse config. Using default.");
                return this.defaultConfig;
            });
            return (T)object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.defaultConfig;
        }
    }

    public void save(T config) {
        File configFolder = new File("config");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        try (FileWriter writer = new FileWriter(this.file);){
            JsonElement json = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, config).result().orElseGet(() -> {
                System.err.println("Failed to encode config. Using default fallback.");
                return new JsonObject();
            });
            PRETTY_GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

