/*
 * Decompiled with CFR 0.152.
 */
package dev.greendata.dimensionlocker.managers;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseManager {
    private static Connection connection;

    public static void initialize() {
        try {
            File dbFolder = new File("db");
            if (!dbFolder.exists()) {
                dbFolder.mkdirs();
            }
            File dbFile = new File(dbFolder, "lockedDimension.sqlite3");
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            connection = DriverManager.getConnection(url);
            System.out.println("[MyMod] SQLite connected at " + dbFile.getAbsolutePath());
            try (Statement stmt = connection.createStatement();){
                String sql = "    CREATE TABLE IF NOT EXISTS locked_dimensions (\n        identity TEXT PRIMARY KEY\n    );\n";
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Connection getConnection() {
        return connection;
    }

    public static void close() {
        if (connection != null) {
            try {
                connection.close();
                System.out.println("[MyMod] SQLite connection closed.");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

