/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UserListWidget
extends class_4280<UserListEntry> {
    private final FriendsScreen screen;

    public UserListWidget(FriendsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users) {
        users.forEach(user -> this.addEntry(new UserListEntry((User)user)));
    }

    public int method_25322() {
        return super.method_25322() + 85;
    }

    public int addEntry(UserListEntry entry) {
        return super.method_25321((class_350.class_351)entry.init(this.screen));
    }

    protected int method_25329() {
        return super.method_25329() + 30;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public static class UserListEntry
    extends class_4280.class_4281<UserListEntry> {
        private final User user;
        private final class_310 client = class_310.method_1551();
        private long time;
        private class_2561 note;
        private FriendsScreen screen;
        private boolean outgoingRequest;

        public UserListEntry(User user, class_5250 note) {
            this(user);
            this.note = note.method_27692(class_124.field_1056);
        }

        public UserListEntry(User user) {
            this.user = user;
        }

        public UserListEntry init(FriendsScreen screen) {
            this.screen = screen;
            return this;
        }

        public UserListEntry outgoing() {
            this.outgoingRequest = true;
            return this;
        }

        public class_2561 method_37006() {
            return class_2561.method_30163((String)this.user.getName());
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.user.isSystem()) {
                class_5250 fronters = class_2561.method_43470((String)this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/")));
                class_5250 tag = class_2561.method_43470((String)("(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
                graphics.method_51439(this.client.field_1772, (class_2561)fronters.method_10852((class_2561)tag), x + 3, y + 1, -1, false);
            } else {
                graphics.method_51433(this.client.field_1772, this.user.getName(), x + 3 + 33, y + 1, -1, false);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                graphics.method_51433(this.client.field_1772, this.user.getStatus().getTitle(), x + 3 + 33, y + 12, 0x808080, false);
                graphics.method_51433(this.client.field_1772, this.user.getStatus().getDescription(), x + 3 + 40, y + 23, 0x808080, false);
            } else if (this.user.getStatus().getLastOnline() != null) {
                graphics.method_51433(this.client.field_1772, this.user.getStatus().getLastOnline(), x + 3 + 33, y + 12, 0x808080, false);
            }
            if (this.note != null) {
                graphics.method_51439(this.client.field_1772, this.note, x + entryWidth - this.client.field_1772.method_27525((class_5348)this.note) - 4, y + entryHeight - 10, 0x808080, false);
            }
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user.getUuid());
            RenderSystem.enableBlend();
            graphics.method_25293(texture, x - 1, y - 1, 33, 33, 8.0f, 8.0f, 8, 8, 64, 64);
            graphics.method_25293(texture, x - 1, y - 1, 33, 33, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.screen.select(this);
            if (class_156.method_658() - this.time < 250L && this.client.field_1687 == null) {
                this.screen.openChat();
            }
            this.time = class_156.method_658();
            return false;
        }

        @Generated
        public User getUser() {
            return this.user;
        }

        @Generated
        public boolean isOutgoingRequest() {
            return this.outgoingRequest;
        }
    }
}

