/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.util.UUIDHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_5250;
import net.minecraft.class_642;

public class ServerInfoUtil {
    public static Status.Activity.ServerInfo getServerInfo(String levelName, class_2926 status) {
        if (status == null) {
            return new Status.Activity.ServerInfo(levelName, null, null, null, null);
        }
        return new Status.Activity.ServerInfo(levelName, status.comp_1273().getString(), new Status.Activity.ServerInfo.Favicon((byte[])status.comp_1276().map(class_2926.class_8145::comp_1278).orElse(null)), (Status.Activity.ServerInfo.Players)status.comp_1274().map(p -> new Status.Activity.ServerInfo.Players(p.comp_1279(), p.comp_1280(), p.comp_1281().stream().map(prof -> new Status.Activity.ServerInfo.Players.Player(prof.getName(), UUIDHelper.toUndashed((UUID)prof.getId()))).toList())).orElse(null), (Status.Activity.ServerInfo.Version)status.comp_1275().map(v -> new Status.Activity.ServerInfo.Version(v.comp_1282(), v.comp_1283())).orElse(null));
    }

    public static class_2926 getServerStatus(Status.Activity.ServerInfo info) {
        return new class_2926(class_2561.method_30163((String)info.levelName()), Optional.ofNullable(info.players()).map(p -> new class_2926.class_2927(p.max(), p.online(), p.sample().stream().map(prof -> new GameProfile(UUIDHelper.fromUndashed((String)prof.uuid()), prof.name())).toList())), Optional.ofNullable(info.version()).map(v -> new class_2926.class_2930(v.name(), v.protocol())), Optional.ofNullable(info.icon()).map(f -> new class_2926.class_8145(f.iconBytes())), false);
    }

    public static class_642 getServerData(String username, Status.Activity.E4mcMetadata metadata) {
        class_2926 serverMetadata = metadata.serverInfo() != null ? ServerInfoUtil.getServerStatus(metadata.serverInfo()) : null;
        class_642 data = new class_642(username, metadata.domain(), false);
        if (serverMetadata != null) {
            serverMetadata.comp_1276().ifPresent(icon -> data.method_49305(icon.comp_1278()));
            data.field_3757 = class_2561.method_43470((String)metadata.serverInfo().levelName());
            serverMetadata.comp_1275().ifPresentOrElse(ver -> {
                data.field_3760 = class_2561.method_43470((String)ver.comp_1282());
                data.field_3756 = ver.comp_1283();
            }, () -> {
                data.field_3760 = class_2561.method_43471((String)"multiplayer.status.old");
                data.field_3756 = 0;
            });
            serverMetadata.comp_1274().ifPresentOrElse(player -> {
                data.field_3753 = class_2561.method_43470((String)Integer.toString(player.comp_1280())).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1063)).method_27693(Integer.toString(player.comp_1279())).method_27692(class_124.field_1080);
                data.field_41861 = player;
                if (!player.comp_1281().isEmpty()) {
                    ArrayList<class_5250> list = new ArrayList<class_5250>(player.comp_1281().size());
                    for (GameProfile gameProfile : player.comp_1281()) {
                        list.add(class_2561.method_43470((String)gameProfile.getName()));
                    }
                    if (player.comp_1281().size() < player.comp_1280()) {
                        list.add(class_2561.method_43469((String)"multiplayer.status.and_more", (Object[])new Object[]{player.comp_1280() - player.comp_1281().size()}));
                    }
                    data.field_3762 = list;
                } else {
                    data.field_3762 = List.of();
                }
            }, () -> {
                data.field_3757 = class_2561.method_43471((String)"multiplayer.status.unknown").method_27692(class_124.field_1063);
            });
        }
        return data;
    }
}

