/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.config.screen.CreditsScreen;
import io.github.axolotlclient.modules.AbstractModule;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class ModuleLoader {
    public static List<AbstractModule> loadExternalModules() {
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
        FabricLoader.getInstance().getEntrypointContainers("axolotlclient.module", AbstractModule.class).forEach(entrypoint -> {
            try {
                AbstractModule module = (AbstractModule)entrypoint.getEntrypoint();
                if (module != null) {
                    modules.add(module);
                    String modName = entrypoint.getProvider().getMetadata().getName();
                    ModMetadata data = entrypoint.getProvider().getMetadata();
                    ArrayList<String> authorsNContributors = new ArrayList<String>();
                    List<String> authors = data.getAuthors().stream().map(Person::getName).toList();
                    authorsNContributors.add("Author(s):");
                    authorsNContributors.addAll(authors);
                    authorsNContributors.add("");
                    authorsNContributors.add("Contributor(s):");
                    authorsNContributors.addAll(data.getContributors().stream().map(Person::getName).toList());
                    CreditsScreen.externalModuleCredits.put(modName, authorsNContributors.toArray(new String[0]));
                }
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.warn("Skipping module: " + entrypoint.getProvider().getMetadata().getName() + " because of error:", new Object[]{e});
            }
        });
        return modules;
    }
}

