/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.blur;

import com.google.gson.JsonSyntaxException;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import java.io.IOException;
import lombok.Generated;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;

public class MotionBlur
extends AbstractModule {
    private static final MotionBlur Instance = new MotionBlur();
    public final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    public final FloatOption strength = new FloatOption("strength", Float.valueOf(50.0f), Float.valueOf(1.0f), Float.valueOf(99.0f));
    public final BooleanOption inGuis = new BooleanOption("inGuis", Boolean.valueOf(false));
    public final OptionCategory category = OptionCategory.create((String)"motionBlur");
    private final class_2960 shaderLocation = new class_2960("minecraft:shaders/post/motion_blur.json");
    private final class_310 client = class_310.method_1551();
    public class_279 shader;
    private float currentBlur;
    private int lastWidth;
    private int lastHeight;

    private static float getBlur() {
        return ((Float)MotionBlur.getInstance().strength.get()).floatValue() / 100.0f;
    }

    public void init() {
        this.category.add(new Option[]{this.enabled, this.strength, this.inGuis});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.category});
        AxolotlClient.runtimeResources.put(this.shaderLocation, new MotionBlurShader());
    }

    public void onUpdate() {
        if ((this.shader == null || class_310.method_1551().method_1522().field_1482 != this.lastWidth || class_310.method_1551().method_1522().field_1481 != this.lastHeight) && class_310.method_1551().method_1522().field_1482 > 0 && class_310.method_1551().method_1522().field_1481 > 0) {
            this.currentBlur = MotionBlur.getBlur();
            try {
                this.shader = new class_279(this.client.method_1531(), this.client.method_1478(), this.client.method_1522(), this.shaderLocation);
                this.shader.method_1259(class_310.method_1551().method_1522().field_1482, class_310.method_1551().method_1522().field_1481);
            }
            catch (JsonSyntaxException | IOException e) {
                AxolotlClient.LOGGER.error("Could not load motion blur: ", new Object[]{e});
            }
        }
        if (this.currentBlur != MotionBlur.getBlur() && this.shader != null) {
            ((ShaderEffectAccessor)this.shader).axolotlclient$getPasses().forEach(shader -> {
                class_284 blendFactor = shader.method_1295().method_1271("BlendFactor");
                if (blendFactor != null) {
                    blendFactor.method_1251(MotionBlur.getBlur());
                }
            });
            this.currentBlur = MotionBlur.getBlur();
        }
        this.lastWidth = class_310.method_1551().method_1522().field_1482;
        this.lastHeight = class_310.method_1551().method_1522().field_1481;
    }

    @Generated
    public static MotionBlur getInstance() {
        return Instance;
    }

    private static class MotionBlurShader
    extends class_3298 {
        public MotionBlurShader() {
            super((class_3262)class_310.method_1551().method_45573(), () -> IOUtils.toInputStream((String)String.format("{\"targets\": [\"swap\",\"previous\"],\"passes\": [{            \"name\": \"motion_blur\",            \"intarget\": \"minecraft:main\",            \"outtarget\": \"swap\",            \"auxtargets\": [                {                    \"name\": \"PrevSampler\",                    \"id\": \"previous\"                }            ],            \"uniforms\": [                {                    \"name\": \"BlendFactor\",                    \"values\": [ %s ]                }            ]        },        {            \"name\": \"blit\",            \"intarget\": \"swap\",            \"outtarget\": \"previous\"        },        {            \"name\": \"blit\",            \"intarget\": \"swap\",            \"outtarget\": \"minecraft:main\"        }    ]}", Float.valueOf(MotionBlur.getBlur())), (String)"utf-8"));
        }
    }
}

