/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DebugCountersHud
extends TextHudEntry {
    public static final class_2960 ID = new class_2960("axolotlclient", "debugcountershud");
    private final BooleanOption showCCount = new BooleanOption("debugcounters.ccount", Boolean.valueOf(true));
    private final BooleanOption showECount = new BooleanOption("debugcounters.ecount", Boolean.valueOf(false));
    private final BooleanOption showPCount = new BooleanOption("debugcounters.pcount", Boolean.valueOf(false));
    private final class_310 client;

    public DebugCountersHud() {
        super(115, 32, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext graphics, float delta) {
        if (this.client.field_1687 == null) {
            this.renderPlaceholderComponent(graphics, delta);
        }
        DrawPosition pos = this.getContentPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString(this.client.field_1769.method_3289(), lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString(this.client.field_1769.method_3272(), lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString("P: " + this.client.field_1713.method_3052(), lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getContentHeight() + pos.y()) {
            boundsChanged = true;
            this.setContentHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getContentWidth()) {
            boundsChanged = true;
            this.setContentWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        DrawPosition pos = this.getContentPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString("C: 186/15000 (s) D: 10, pC: 000, pU: 00, aB: 20", lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString("E: 695/3001, SD: 12", lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, graphics.br$drawString("P: 200", lineX, lineY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue()));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getContentHeight() + pos.y()) {
            boundsChanged = true;
            this.setContentHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getContentWidth()) {
            boundsChanged = true;
            this.setContentWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public class_2960 getId() {
        return ID;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.showCCount);
        options.add(this.showECount);
        options.add(this.showPCount);
        return options;
    }
}

