/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ScoreboardHud
extends TextHudEntry {
    public static final class_2960 ID = new class_2960("kronhud", "scoreboardhud");
    public static final class_266 placeholder = (class_266)class_156.method_656(() -> {
        class_269 placeScore = new class_269();
        class_266 objective = placeScore.method_1168("placeholder", class_274.field_1468, (class_2561)class_2561.method_43470((String)"Scoreboard"), class_274.class_275.field_1472);
        class_267 dark = placeScore.method_1180("DarkKronicle", objective);
        dark.method_1128(8780);
        class_267 moeh = placeScore.method_1180("moehreag", objective);
        moeh.method_1128(743);
        class_267 kode = placeScore.method_1180("TheKodeToad", objective);
        kode.method_1128(2948);
        placeScore.method_1158(1, objective);
        return objective;
    });
    private final ColorOption backgroundColor = new ColorOption("backgroundcolor", new Color(0x4C000000));
    private final ColorOption topColor = new ColorOption("topbackgroundcolor", new Color(0x66000000));
    private final IntegerOption topPadding = new IntegerOption("toppadding", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(4));
    private final BooleanOption scores = new BooleanOption("scores", Boolean.valueOf(true));
    private final ColorOption scoreColor = new ColorOption("scorecolor", new Color(-43691));
    private final IntegerOption textAlpha = new IntegerOption("text_alpha", Integer.valueOf(255), Integer.valueOf(0), Integer.valueOf(255));
    private final class_310 client;

    public ScoreboardHud() {
        super(200, 146, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void render(AxoRenderContext graphics, float delta) {
        graphics.br$pushMatrix();
        this.scale(graphics);
        this.renderComponent(graphics, delta);
        graphics.br$popMatrix();
    }

    public void renderComponent(AxoRenderContext graphics, float delta) {
        class_266 scoreboardObjective2;
        int t;
        class_269 scoreboard = this.client.field_1687.method_8428();
        class_266 scoreboardObjective = null;
        class_268 team = scoreboard.method_1164(this.client.field_1724.method_5820());
        if (team != null && (t = team.method_1202().method_536()) >= 0) {
            scoreboardObjective = scoreboard.method_1189(3 + t);
        }
        class_266 class_2662 = scoreboardObjective2 = scoreboardObjective != null ? scoreboardObjective : scoreboard.method_1189(1);
        if (scoreboardObjective2 != null) {
            this.renderScoreboardSidebar((class_332)graphics, scoreboardObjective2);
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        this.renderScoreboardSidebar((class_332)graphics, placeholder);
    }

    private void renderScoreboardSidebar(class_332 graphics, class_266 objective) {
        int displayNameWidth;
        class_269 scoreboard = objective.method_1117();
        ArrayList scores = scoreboard.method_1184(objective);
        ArrayList filteredScores = scores.stream().filter(testScore -> testScore.method_1129() != null && !testScore.method_1129().startsWith("#")).collect(Collectors.toList());
        scores = filteredScores.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(filteredScores, (int)(scores.size() - 15))) : filteredScores;
        ArrayList scoresWText = Lists.newArrayListWithCapacity((int)scores.size());
        class_2561 text = objective.method_1114();
        int maxWidth = displayNameWidth = this.client.field_1772.method_27525((class_5348)text);
        int spacerWidth = this.client.field_1772.method_1727(": ");
        for (class_267 scoreboardPlayerScore : scores) {
            class_268 team = scoreboard.method_1164(scoreboardPlayerScore.method_1129());
            class_5250 formattedText = class_268.method_1142((class_270)team, (class_2561)class_2561.method_43470((String)scoreboardPlayerScore.method_1129()));
            scoresWText.add(Pair.of((Object)scoreboardPlayerScore, (Object)formattedText));
            maxWidth = Math.max(maxWidth, this.client.field_1772.method_27525((class_5348)formattedText) + spacerWidth + this.client.field_1772.method_1727(Integer.toString(scoreboardPlayerScore.method_1126())));
        }
        maxWidth += 6;
        int scoresSize = scores.size();
        int scoreHeight = scoresSize * 9;
        int fullHeight = scoreHeight + 11 + (Integer)this.topPadding.get() * 2;
        boolean updated = false;
        if (fullHeight + 1 != this.height) {
            this.setHeight(fullHeight + 1);
            updated = true;
        }
        if (maxWidth + 1 != this.width) {
            this.setWidth(maxWidth + 1);
            updated = true;
        }
        if (updated) {
            this.onBoundsUpdate();
        }
        Rectangle bounds = this.getBounds();
        int renderX = bounds.x() + bounds.width() - maxWidth;
        int renderY = bounds.y() + (bounds.height() / 2 - fullHeight / 2) + 1;
        int scoreX = renderX + 4;
        int scoreY = renderY + scoreHeight + 10;
        int num = 0;
        int textOffset = scoreX - 4;
        for (Pair scoreboardPlayerScoreTextPair : scoresWText) {
            class_267 scoreboardPlayerScore2 = (class_267)scoreboardPlayerScoreTextPair.getFirst();
            class_2561 scoreText = (class_2561)scoreboardPlayerScoreTextPair.getSecond();
            String score = String.valueOf(scoreboardPlayerScore2.method_1126());
            int relativeY = scoreY - ++num * 9 + (Integer)this.topPadding.get() * 2;
            if (((Boolean)this.background.get()).booleanValue() && this.backgroundColor.get().toInt() > 0) {
                if (num == scoresSize) {
                    RenderUtil.drawRectangle(graphics, textOffset, relativeY - 1, maxWidth, 10, this.backgroundColor.get().toInt());
                } else if (num == 1) {
                    RenderUtil.drawRectangle(graphics, textOffset, relativeY, maxWidth, 10, this.backgroundColor.get().toInt());
                } else {
                    RenderUtil.drawRectangle(graphics, textOffset, relativeY, maxWidth, 9, this.backgroundColor.get().toInt());
                }
            }
            graphics.method_51439(this.client.field_1772, scoreText, scoreX, relativeY, Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt(), ((Boolean)this.shadow.get()).booleanValue());
            if (((Boolean)this.scores.get()).booleanValue()) {
                DrawUtil.drawString(graphics, score, (float)(scoreX + maxWidth - this.client.field_1772.method_1727(score) - 6), (float)relativeY, this.scoreColor.get().toInt(), (boolean)((Boolean)this.shadow.get()));
            }
            if (num != scoresSize) continue;
            if (((Boolean)this.background.get()).booleanValue()) {
                RenderUtil.drawRectangle(graphics, textOffset, relativeY - 10 - (Integer)this.topPadding.get() * 2 - 1, maxWidth, 10 + (Integer)this.topPadding.get() * 2, this.topColor.get());
            }
            float title = renderX + (maxWidth - displayNameWidth) / 2;
            graphics.method_51439(this.client.field_1772, text, (int)title, relativeY - 9 - (Integer)this.topPadding.get(), Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt(), ((Boolean)this.shadow.get()).booleanValue());
        }
        if (((Boolean)this.outline.get()).booleanValue() && this.outlineColor.get().getAlpha() > 0) {
            RenderUtil.drawOutline(graphics, textOffset, bounds.y(), maxWidth, fullHeight + 2, this.outlineColor.get());
        }
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.remove(this.backgroundPadding);
        options.remove(this.backgroundRounding);
        options.remove(this.roundBackground);
        options.set(options.indexOf(((TextHudEntry)this).backgroundColor), this.backgroundColor);
        options.add(this.hide);
        options.add(this.topColor);
        options.add(this.scores);
        options.add(this.scoreColor);
        options.add(this.topPadding);
        options.remove(this.textColor);
        options.add(this.textAlpha);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    public double getDefaultX() {
        return 1.0;
    }

    public double getDefaultY() {
        return 0.5;
    }

    protected AnchorPoint getDefaultAnchor() {
        return AnchorPoint.MIDDLE_RIGHT;
    }
}

