/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class DrawUtil {
    public static void fillRect(class_332 graphics, Rectangle rectangle, Color color) {
        DrawUtil.fillRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void fillRect(class_332 graphics, int x, int y, int width, int height, int color) {
        graphics.method_25294(x, y, x + width, y + height, color);
    }

    public static void outlineRect(class_332 graphics, Rectangle rectangle, Color color) {
        DrawUtil.outlineRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void outlineRect(class_332 graphics, int x, int y, int width, int height, int color) {
        DrawUtil.fillRect(graphics, x, y, 1, height - 1, color);
        DrawUtil.fillRect(graphics, x + width - 1, y + 1, 1, height - 1, color);
        DrawUtil.fillRect(graphics, x + 1, y, width - 1, 1, color);
        DrawUtil.fillRect(graphics, x, y + height - 1, width - 1, 1, color);
    }

    public static void drawCenteredString(class_332 graphics, class_327 renderer, String text, int x, int y, Color color, boolean shadow) {
        DrawUtil.drawCenteredString(graphics, renderer, text, x, y, color.toInt(), shadow);
    }

    public static void drawCenteredString(class_332 graphics, class_327 renderer, String text, int x, int y, int color, boolean shadow) {
        DrawUtil.drawString(graphics, text, (float)(x - renderer.method_1727(text) / 2), (float)y, color, shadow);
    }

    public static void drawString(class_332 graphics, String text, float x, float y, int color, boolean shadow) {
        graphics.method_51433(class_310.method_1551().field_1772, text, (int)x, (int)y, color, shadow);
    }

    public static void drawString(class_332 graphics, String text, float x, float y, Color color, boolean shadow) {
        DrawUtil.drawString(graphics, text, x, y, color.toInt(), shadow);
    }

    public static void blitSprite(class_332 graphics, class_2960 texture, int i, int j, int k, int l, GuiSpriteScaling guiSpriteScaling) {
        DrawUtil.blitSprite(graphics, texture, i, j, k, l, -1, guiSpriteScaling);
    }

    public static void blitSprite(class_332 graphics, class_2960 resourceLocation, int i, int j, int k, int l, int m, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(graphics, resourceLocation, i, j, k, l, m);
        } else if (guiSpriteScaling instanceof Tile) {
            Tile tile = (Tile)guiSpriteScaling;
            DrawUtil.blitTiledSprite(graphics, resourceLocation, i, j, k, l, 0, 0, tile.width(), tile.height(), tile.width(), tile.height(), m);
        } else if (guiSpriteScaling instanceof NineSlice) {
            NineSlice nineSlice = (NineSlice)guiSpriteScaling;
            DrawUtil.blitNineSlicedSprite(graphics, resourceLocation, nineSlice, i, j, k, l, m);
        }
    }

    public static void blitSprite(class_332 graphics, class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(graphics, resourceLocation, i, j, k, l, m, n, o, p, -1);
        } else {
            graphics.method_44379(m, n, m + o, n + p);
            DrawUtil.blitSprite(graphics, resourceLocation, m - k, n - l, i, j, -1);
            graphics.method_44380();
        }
    }

    public static void blitSprite(class_332 graphics, class_2960 texture, int i, int j, int k, int l) {
        DrawUtil.blitSprite(graphics, texture, i, j, k, l, -1);
    }

    public static void blitSprite(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            DrawUtil.innerBlit(graphics, texture, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
        }
    }

    private static void blitSprite(class_332 graphics, class_2960 texture, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        if (o != 0 && p != 0) {
            DrawUtil.innerBlit(graphics, texture, m, m + o, n, n + p, (float)k / (float)i, (float)(k + o) / (float)i, (float)l / (float)j, (float)(l + p) / (float)j, q);
        }
    }

    private static void blitNineSlicedSprite(class_332 graphics, class_2960 texture, NineSlice nineSlice, int i, int j, int k, int l, int m) {
        Border border = nineSlice.border();
        int n = Math.min(border.left(), k / 2);
        int o = Math.min(border.right(), k / 2);
        int p = Math.min(border.top(), l / 2);
        int q = Math.min(border.bottom(), l / 2);
        if (k == nineSlice.width() && l == nineSlice.height()) {
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, l, m);
        } else if (l == nineSlice.height()) {
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, n, l, m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i + n, j, k - o - n, l, n, 0, nineSlice.width() - o - n, nineSlice.height(), nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + k - o, j, o, l, m);
        } else if (k == nineSlice.width()) {
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, p, m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i, j + p, k, l - q - p, 0, p, nineSlice.width(), nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + l - q, k, q, m);
        } else {
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, 0, i, j, n, p, m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i + n, j, k - o - n, p, n, 0, nineSlice.width() - o - n, p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + k - o, j, o, p, m);
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + l - q, n, q, m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i + n, j + l - q, k - o - n, q, n, nineSlice.height() - q, nineSlice.width() - o - n, q, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitSprite(graphics, texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, nineSlice.height() - q, i + k - o, j + l - q, o, q, m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i, j + p, n, l - q - p, 0, p, n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i + n, j + p, k - o - n, l - q - p, n, p, nineSlice.width() - o - n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
            DrawUtil.blitNineSliceInnerSegment(graphics, texture, nineSlice, i + k - o, j + p, o, l - q - p, nineSlice.width() - o, p, o, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height(), m);
        }
    }

    private static void blitNineSliceInnerSegment(class_332 graphics, class_2960 texture, NineSlice nineSlice, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        if (k > 0 && l > 0) {
            if (nineSlice.stretchInner()) {
                DrawUtil.innerBlit(graphics, texture, i, i + k, j, j + l, (float)m / (float)q, (float)(m + o) / (float)q, (float)n / (float)r, (float)(n + p) / (float)r, s);
            } else {
                DrawUtil.blitTiledSprite(graphics, texture, i, j, k, l, m, n, o, p, q, r, s);
            }
        }
    }

    private static void blitTiledSprite(class_332 graphics, class_2960 texture, int i, int j, int k, int l, int m, int n, int width, int height, int q, int r, int s) {
        if (k > 0 && l > 0) {
            if (width > 0 && height > 0) {
                for (int t = 0; t < k; t += width) {
                    int u = Math.min(width, k - t);
                    for (int v = 0; v < l; v += height) {
                        int w = Math.min(height, l - v);
                        DrawUtil.blitSprite(graphics, texture, q, r, m, n, i + t, j + v, u, w, s);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + width + "x" + height);
            }
        }
    }

    private static void innerBlit(class_332 graphics, class_2960 resourceLocation, int x, int x2, int y, int y2, float u, float u2, float v, float v2, int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_22913(u, v).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y2, 0.0f).method_1336(red, green, blue, alpha).method_22913(u, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_1336(red, green, blue, alpha).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_22913(u2, v).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface GuiSpriteScaling {
    }

    public record Stretch() implements GuiSpriteScaling
    {
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
    }

    public record NineSlice(int width, int height, Border border, boolean stretchInner) implements GuiSpriteScaling
    {
    }

    public record Border(int left, int right, int top, int bottom) {
    }
}

