/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.AbstractCommonModule;
import io.github.axolotlclient.modules.sky.FSBSkyboxInstance;
import io.github.axolotlclient.modules.sky.MCPSkyboxInstance;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public class SkyResourceManager
extends AbstractCommonModule
implements SimpleSynchronousResourceReloadListener {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final SkyResourceManager Instance = new SkyResourceManager();

    public void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject loadMCPSky(String loader, class_2960 id, class_3298 resource) {
        JsonObject object = new JsonObject();
        try (BufferedReader reader = resource.method_43039();){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] option = line.split("=");
                if (option[0].equals("source")) {
                    if (!option[1].contains(":")) {
                        if (option[1].startsWith("assets")) {
                            option[1] = option[1].replace("./", "").replace("assets/minecraft/", "");
                        } else if (id.method_12832().contains("world")) {
                            option[1] = loader + "/sky/world" + id.method_12832().split("world")[1].split("/")[0] + "/" + option[1].replace("./", "");
                        }
                    }
                    if (class_310.method_1551().method_1478().method_14486(new class_2960(option[1])).isEmpty()) {
                        AxolotlClient.LOGGER.warn("Sky " + String.valueOf(id) + " does not have a valid texture attached to it: ", new Object[]{option[1]});
                        AxolotlClient.LOGGER.warn("Please fix your packs.", new Object[0]);
                        JsonObject jsonObject = null;
                        return jsonObject;
                    }
                }
                if (option[0].equals("startFadeIn") || option[0].equals("endFadeIn") || option[0].equals("startFadeOut") || option[0].equals("endFadeOut")) {
                    option[1] = option[1].replace(":", "").replace("\\", "");
                }
                object.addProperty(option[0], option[1]);
            }
            return object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @NotNull
    public class_2960 getFabricId() {
        return new class_2960("axolotlclient", "custom_skies");
    }

    public void method_14491(class_3300 manager) {
        JsonObject json;
        AxolotlClient.LOGGER.debug("Loading Custom Skies!", new Object[0]);
        SkyboxManager.getInstance().clearSkyboxes();
        for (Map.Entry entry : manager.method_14488("sky", identifier -> identifier.method_12832().endsWith(".json")).entrySet()) {
            if (((class_2960)entry.getKey()).method_12836().equals("celestial")) continue;
            AxolotlClient.LOGGER.debug("Loading FSB sky from " + String.valueOf(entry.getKey()), new Object[0]);
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonObject json2 = (JsonObject)gson.fromJson(reader.lines().collect(Collectors.joining("\n")), JsonObject.class);
                    if (!json2.has("type") || !json2.get("type").getAsString().equals("square-textured")) {
                        AxolotlClient.LOGGER.debug("Skipping " + String.valueOf(entry) + " as we currently cannot load it!", new Object[0]);
                        continue;
                    }
                    SkyboxManager.getInstance().addSkybox(new FSBSkyboxInstance(json2));
                    AxolotlClient.LOGGER.debug("Loaded FSB sky from " + String.valueOf(entry.getKey()), new Object[0]);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException reader) {}
        }
        for (Map.Entry entry : manager.method_14488("mcpatcher/sky", identifier -> this.isMCPSky(identifier.method_12832())).entrySet()) {
            AxolotlClient.LOGGER.debug("Loading MCP sky from " + String.valueOf(entry.getKey()), new Object[0]);
            json = SkyResourceManager.loadMCPSky("mcpatcher", (class_2960)entry.getKey(), (class_3298)entry.getValue());
            if (json == null) continue;
            SkyboxManager.getInstance().addSkybox(new MCPSkyboxInstance(json));
            AxolotlClient.LOGGER.debug("Loaded MCP sky from " + String.valueOf(entry.getKey()), new Object[0]);
        }
        for (Map.Entry entry : manager.method_14488("optifine/sky", identifier -> this.isMCPSky(identifier.method_12832())).entrySet()) {
            AxolotlClient.LOGGER.debug("Loading OF sky from " + String.valueOf(entry.getKey()), new Object[0]);
            json = SkyResourceManager.loadMCPSky("optifine", (class_2960)entry.getKey(), (class_3298)entry.getValue());
            if (json == null) continue;
            SkyboxManager.getInstance().addSkybox(new MCPSkyboxInstance(json));
            AxolotlClient.LOGGER.debug("Loaded OF sky from " + String.valueOf(entry.getKey()), new Object[0]);
        }
        AxolotlClient.LOGGER.debug("Finished Loading Custom Skies!", new Object[0]);
    }

    private boolean isMCPSky(String path) {
        return path.endsWith(".properties") && path.substring(path.lastIndexOf("/") + 1).startsWith("sky");
    }

    @Generated
    public static SkyResourceManager getInstance() {
        return Instance;
    }
}

