/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.mixin.WorldRendererAccessor;
import io.github.axolotlclient.util.Util;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL14;

public abstract class SkyboxInstance {
    protected final class_2960 MOON_PHASES = new class_2960("textures/environment/moon_phases.png");
    protected final class_2960 SUN = new class_2960("textures/environment/sun.png");
    protected int blendMode = 1;
    protected boolean alwaysOn;
    protected float maxAlpha = 1.0f;
    protected boolean manualBlend = false;
    protected int blendSrcFactor = 1;
    protected int blendDstFactor = 1;
    protected int blendEquation;
    protected boolean rotate = false;
    protected float rotationSpeed = 1.0f;
    protected float[] rotationStatic = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotationAxis = new float[]{0.0f, 0.0f, 0.0f};
    protected boolean showSun = true;
    protected boolean showMoon = true;
    protected boolean showStars = true;
    JsonObject object;
    float alpha = 1.0f;
    class_2960[] textures = new class_2960[6];
    int[] fade = new int[4];

    public SkyboxInstance(JsonObject json) {
        this.object = json;
    }

    public float getAlpha() {
        int tempOutTime;
        int tempFullTime;
        int tempInTime;
        if (this.alwaysOn) {
            return 1.0f;
        }
        int currentTime = (int)Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() % 24000;
        int durationIn = Util.getTicksBetween(this.fade[0], this.fade[1]);
        int durationOut = Util.getTicksBetween(this.fade[2], this.fade[3]);
        int endFadeIn = this.fade[1] % 24000;
        int startFadeIn = this.fade[0] % 24000;
        if (endFadeIn < startFadeIn) {
            endFadeIn += 24000;
        }
        int startFadeOut = this.fade[2] % 24000;
        int endFadeOut = this.fade[3] % 24000;
        if (startFadeOut < endFadeIn) {
            startFadeOut += 24000;
        }
        if (endFadeOut < startFadeOut) {
            endFadeOut += 24000;
        }
        if ((tempInTime = currentTime) < startFadeIn) {
            tempInTime += 24000;
        }
        if ((tempFullTime = currentTime) < endFadeIn) {
            tempFullTime += 24000;
        }
        if ((tempOutTime = currentTime) < startFadeOut) {
            tempOutTime += 24000;
        }
        float maxPossibleAlpha = startFadeIn < tempInTime && endFadeIn >= tempInTime ? 1.0f - (float)(endFadeIn - tempInTime) / (float)durationIn : (endFadeIn < tempFullTime && startFadeOut >= tempFullTime ? 1.0f : (startFadeOut < tempOutTime && endFadeOut >= tempOutTime ? (float)(endFadeOut - tempOutTime) / (float)durationOut : 0.0f));
        this.alpha = class_3532.method_15363((float)(maxPossibleAlpha * this.maxAlpha), (float)0.0f, (float)1.0f);
        return this.alpha;
    }

    protected int parseBlend(String str) {
        if (str == null) {
            return 1;
        }
        switch (str.toLowerCase(Locale.ENGLISH).trim()) {
            case "alpha": {
                return 0;
            }
            case "add": {
                return 1;
            }
            case "subtract": {
                return 2;
            }
            case "multiply": {
                return 3;
            }
            case "dodge": {
                return 4;
            }
            case "burn": {
                return 5;
            }
            case "screen": {
                return 6;
            }
            case "overlay": {
                return 7;
            }
            case "replace": {
                return 8;
            }
        }
        AxolotlClient.LOGGER.warn("Unknown blend: " + str, new Object[0]);
        return 1;
    }

    public void render(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, Runnable runnable) {
        float brightness = class_310.method_1551().field_1687.method_8430(tickDelta);
        matrices.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        this.setupBlend(brightness);
        this.setupRotate(matrices, tickDelta, brightness);
        this.renderSkybox(matrices);
        this.clearBlend(brightness);
        this.clearRotate(matrices);
        matrices.method_22909();
        this.renderDecorations(matrices, projectionMatrix, tickDelta, runnable);
    }

    protected void setupBlend(float brightness) {
        if (this.manualBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)this.blendSrcFactor, (int)this.blendDstFactor);
            GL14.glBlendEquation((int)this.blendEquation);
            return;
        }
        switch (this.blendMode) {
            case 0: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                break;
            }
            case 1: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                break;
            }
            case 2: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)775, (int)0);
                break;
            }
            case 3: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)774, (int)771);
                break;
            }
            case 4: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)1, (int)1);
                break;
            }
            case 5: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)0, (int)769);
                break;
            }
            case 6: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)1, (int)769);
                break;
            }
            case 7: {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)774, (int)768);
                break;
            }
            case 8: {
                RenderSystem.disableBlend();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
    }

    protected void setupRotate(class_4587 matrices, float delta, float brightness) {
        matrices.method_22907(class_7833.field_40714.rotationDegrees(this.rotationStatic[0]));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(this.rotationStatic[1]));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(this.rotationStatic[2]));
        if (this.rotate) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(this.rotationAxis[0]));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(this.rotationAxis[1]));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(this.rotationAxis[2]));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40713.rotationDegrees(class_310.method_1551().field_1687.method_30274(delta) * 360.0f * this.rotationSpeed));
            matrices.method_22907(class_7833.field_40717.rotationDegrees(this.rotationAxis[0]));
            matrices.method_22907(class_7833.field_40715.rotationDegrees(this.rotationAxis[1]));
            matrices.method_22907(class_7833.field_40713.rotationDegrees(this.rotationAxis[2]));
        }
    }

    public abstract void renderSkybox(class_4587 var1);

    protected void clearBlend(float brightness) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
    }

    protected void clearRotate(class_4587 matrices) {
        matrices.method_22907(class_7833.field_40713.rotationDegrees(this.rotationStatic[0]));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(this.rotationStatic[1]));
        matrices.method_22907(class_7833.field_40717.rotationDegrees(this.rotationStatic[2]));
    }

    protected void renderDecorations(class_4587 matrices, Matrix4f projectionMatrix, float delta, Runnable runnable) {
        WorldRendererAccessor worldRendererAccessor = (WorldRendererAccessor)class_310.method_1551().field_1769;
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        matrices.method_22903();
        float i = 1.0f - class_310.method_1551().field_1687.method_8430(delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(class_310.method_1551().field_1687.method_30274(delta) * 360.0f));
        Matrix4f matrix4f2 = matrices.method_23760().method_23761();
        float k = 30.0f;
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        if (this.showSun) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SUN);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -k, 100.0f, -k).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, 100.0f, -k).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, 100.0f, k).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, -k, 100.0f, k).method_22913(0.0f, 1.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        if (this.showMoon) {
            k = 20.0f;
            RenderSystem.setShaderTexture((int)0, (class_2960)this.MOON_PHASES);
            int r = class_310.method_1551().field_1687.method_30273();
            int s = r % 4;
            int m = r / 4 % 2;
            float t = (float)s / 4.0f;
            float o = (float)m / 2.0f;
            float p = (float)(s + 1) / 4.0f;
            float q = (float)(m + 1) / 2.0f;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -k, -100.0f, k).method_22913(p, q).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, -100.0f, k).method_22913(t, q).method_1344();
            bufferBuilder.method_22918(matrix4f2, k, -100.0f, -k).method_22913(t, o).method_1344();
            bufferBuilder.method_22918(matrix4f2, -k, -100.0f, -k).method_22913(p, o).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        if (this.showStars) {
            float u = class_310.method_1551().field_1687.method_23787(delta) * i;
            if (u > 0.0f) {
                RenderSystem.setShaderColor((float)u, (float)u, (float)u, (float)u);
                class_758.method_23792();
                worldRendererAccessor.axolotlclient$getStarsBuffer().method_1353();
                worldRendererAccessor.axolotlclient$getStarsBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
                class_291.method_1354();
                runnable.run();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
    }
}

