/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.util.notifications.Notifications;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class AddFriendScreen extends SimpleTextInputScreen {
	public AddFriendScreen(C_3020744 parent) {
		super(parent, C_3390001.m_2053009("api.screen.friends.add"), C_3390001.m_2053009("api.screen.friends.add.name"),
			s -> {
				if (API.getInstance().isSocketConnected()) {
					UUIDHelper.ensureUuid(s).thenAccept(FriendRequest.getInstance()::addFriend);
				} else {
					Notifications.getInstance().addStatus("api.error.notLoggedIn", "api.error.notLoggedIn.desc");
				}
			});
	}
}
