/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.api.chat.ChatWidget;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.mixin.ScreenAccessor;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import org.lwjgl.input.Keyboard;

public class ChatsSidebar extends C_3020744 implements ContextMenuScreen {

	private static final int ANIM_STEP = 8;
	private final C_3020744 parent;
	private int sidebarAnimX;
	private int sidebarWidth;
	private boolean remove;
	private boolean hasChat;
	private ListWidget list;
	private C_2925725 input;
	private Channel channel;

	private ChatWidget chatWidget;

	private ContextMenuContainer contextMenu;
	private final String title;

	public ChatsSidebar(C_3020744 parent) {
		super();
		this.title = C_3390001.m_2053009("api.chats.sidebar");
		this.parent = parent;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		if (parent != null) {
			parent.m_7261014(mouseX, mouseY, delta);
		}
		C_3754158.m_8373640();
		C_3754158.m_3172490(0, 0, 1000);
		io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.pushScissor(0, 0, Math.max(0, sidebarWidth + sidebarAnimX), f_3080061);
		m_7865719(sidebarAnimX, 0, sidebarWidth + sidebarAnimX, f_3080061, 0x99000000);

		f_2020658.m_1950885(C_3390001.m_2053009("api.chats"), 10 + sidebarAnimX, 10, -1);

		if (list != null) {
			list.m_9734698(mouseX, mouseY, delta);
		}

		super.m_7261014(mouseX, mouseY, delta);

		if (input != null) {
			input.m_1620442();
		}

		if (hasChat) {
			m_7865719(70 + sidebarAnimX, 0, 70 + sidebarAnimX + 1, f_3080061, 0xFF000000);
			f_2020658.m_1950885(channel.getName(), sidebarAnimX + 75, 20, -1);
			if (channel.isDM() && ((Channel.DM) channel).getReceiver().getStatus().isOnline()) {
				f_2020658.m_1950885(C_1945050.f_8012292 + ((Channel.DM) channel).getReceiver().getStatus().getTitle() + ": " + ((Channel.DM) channel).getReceiver().getStatus().getDescription(),
					sidebarAnimX + 80, 30, 8421504);
			}
			chatWidget.m_9734698(mouseX, mouseY, delta);
		}

		contextMenu.render(f_7153641, mouseX, mouseY);
		animate();
		io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.popScissor();
		C_3754158.m_2041265();
	}

	@Override
	public void m_3593494() {
		removeChat();
		sidebarWidth = 70;
		sidebarAnimX = -sidebarWidth;

		if (parent != null) {
			((ScreenAccessor) parent).getButtons().stream()
				.filter(e -> e.f_4865617.equals(C_3390001.m_2053009("api.chats"))).forEach(e -> e.f_1990467 = false);
		}

		ChannelRequest.getChannelList().whenCompleteAsync((list, t) ->
			this.list = new ListWidget(list, 10, 30, 50, f_3080061 - 70)
		);

		f_2213969.add(new C_2348249(0, 10 - sidebarWidth, f_3080061 - 30, 50, 20, C_3390001.m_2053009("gui.back")));
		contextMenu = new ContextMenuContainer();
	}

	public void remove() {
		remove = true;
	}

	@Override
	public void m_2450377() {
		if (input != null) {
			input.m_0296611();
		}
	}

	@Override
	public void m_8984281() {
		if (chatWidget != null) {
			chatWidget.remove();
		}
	}

	@Override
	public boolean m_0601517() {
		return parent != null && parent.m_0601517();
	}

	private void animate() {
		if (sidebarAnimX < 0 && !remove) {
			if (sidebarAnimX > -ANIM_STEP) {
				sidebarAnimX = -ANIM_STEP;
			}
			sidebarAnimX += ANIM_STEP;
			if (list != null) {
				list.f_1810131 = false;
			}
			f_2213969.forEach(button -> button.f_3923091 = (button.f_3923091 + ANIM_STEP));
		} else if (remove) {
			if (sidebarAnimX <= -sidebarWidth) {
				close();
			}
			sidebarAnimX -= ANIM_STEP;
			if (list != null) {
				list.m_3867153(list.getX() - ANIM_STEP);
			}
			f_2213969.forEach(button -> button.f_3923091 = (button.f_3923091 - ANIM_STEP));
			if (chatWidget != null) {
				chatWidget.m_3867153(chatWidget.getX() - ANIM_STEP);
			}
			if (input != null) {
				input.f_2565579 -= ANIM_STEP;
			}
		} else {
			if (list != null && !list.f_1810131) {
				list.f_1810131 = true;
			}
		}
	}

	private void close() {
		f_7153641.m_6408915(parent);
		if (chatWidget != null) {
			chatWidget.remove();
		}
	}

	@Override
	public void m_7362766(int mouseX, int mouseY, int button) {
		if (contextMenu.getMenu() != null) {
			if (contextMenu.mouseClicked(mouseX, mouseY, button)) {
				return;
			}
			contextMenu.removeMenu();
		}
		if (mouseX > sidebarWidth) {
			remove();
			return;
		}
		if (list != null) {
			list.m_7379893(mouseX, mouseY, button);
		}

		if (input != null) {
			input.m_1129375(mouseX, mouseY, button);
		}
		if (chatWidget != null) {
			chatWidget.m_7379893(mouseX, mouseY, button);
		}
		super.m_7362766(mouseX, mouseY, button);
	}

	private void removeChat() {
		hasChat = false;
		chatWidget = null;
		input = null;
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			remove();
		}
	}

	private void addChat(Channel channel) {
		if (hasChat) {
			removeChat();
		}
		hasChat = true;
		list.elements.forEach(b -> b.f_3831222 = true);
		this.channel = channel;
		int w;
		if (channel.isDM()) {
			User chatUser = ((Channel.DM) channel).getReceiver();
			w = Math.max(f_7153641.f_0426313.m_0040387(chatUser.getStatus().getTitle() + ": " + chatUser.getStatus().getDescription()) + 5,
				f_7153641.f_0426313.m_0040387(channel.getName()));
		} else {
			w = f_7153641.f_0426313.m_0040387(channel.getName());
		}
		sidebarWidth = Math.min(Math.max(f_5465691 * 5 / 12, w + 5), f_5465691 / 2);
		chatWidget = new ChatWidget(channel, 75, 50, sidebarWidth - 80, f_3080061 - 100, this);
		input = new C_2925725(2, f_2020658, 75, f_3080061 - 30, sidebarWidth - 80, 20) {
			@Override
			public boolean m_1973329(char c, int i) {
				if (i == Keyboard.KEY_RETURN) {
					ChatHandler.getInstance().sendMessage(ChatsSidebar.this.channel, input.m_4862541());
					input.m_1464552("");
					return true;
				}
				return super.m_1973329(c, i);
			}

			@Override
			public void m_1620442() {
				super.m_1620442();
				if (m_4862541().isEmpty()) {
					m_6649515(f_2020658, C_3390001.m_2053009("api.friends.chat.input"),
						f_2565579 + 2, f_8286097 + 6, -8355712);
				}
			}
		};
		input.m_1954651(1024);
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return contextMenu;
	}

	@Override
	public C_3020744 getSelf() {
		return this;
	}

	@Override
	public C_3020744 getParent() {
		return parent;
	}

	@Override
	public void m_3356138() {
		super.m_3356138();
		if (list != null) {
			list.m_1002325();
		}
		if (chatWidget != null) {
			chatWidget.m_1002325();
		}
	}

	@Override
	protected void m_6992336(char c, int i) {
		if (input != null) {
			input.m_1973329(c, i);
		}
		super.m_6992336(c, i);
	}

	public interface Action {
		void onPress(ListWidget.UserButton button);
	}

	private class ListWidget extends C_1630332 {
		private final List<UserButton> elements;
		private final int f_5546437 = 25;
		private boolean f_1810131 = true;

		public ListWidget(List<Channel> list, int x, int y, int width, int height) {
			super(C_8105098.m_0408063(), width, height, y, ChatsSidebar.this.f_3080061 - y, 25);
			f_8129586 = x;
			f_7901480 = x + width;
			f_9975269 = y;
			f_9145833 = y + height;
			AtomicInteger buttonY = new AtomicInteger(y);
			elements = list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
				.map(channel -> new UserButton(x, buttonY.getAndAdd(f_5546437), width, f_5546437 - 5,
					channel.getName(), buttonWidget -> {
					addChat(channel);
					buttonWidget.f_3831222 = false;
				})).collect(Collectors.toList());
		}

		public int getX() {
			return f_8129586;
		}

		public void m_3867153(int x) {
			f_8129586 = x;
			f_7901480 = x + f_2695432;
			elements.forEach(e -> e.f_3923091 = x);
		}

		@Override
		protected int m_3791031() {
			return elements.size();
		}

		@Override
		public void m_9734698(int mouseX, int mouseY, float delta) {
			if (this.f_1810131) {
				this.f_9602731 = mouseX;
				this.f_1139530 = mouseY;
				this.m_7189774();
				int m = this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2;
				int n = this.f_9975269 + 4 - (int) this.f_1867063;

				this.m_2972483(m, n, mouseX, mouseY);
			}
		}

		@Override
		protected void m_2972483(int x, int y, int mouseX, int mouseY) {
			DrawUtil.enableScissor(f_8129586, f_9975269, f_8129586 + this.f_2695432, f_9145833);
			super.m_2972483(x, y, mouseX, mouseY);
			DrawUtil.disableScissor();
		}

		@Override
		public C_8277969 m_7118949(int i) {
			return elements.get(i);
		}

		public class UserButton extends C_2348249 implements C_8277969 {
			private final Action action;

			public UserButton(int x, int y, int width, int height, String string, Action action) {
				super(0, x, y, width, height, string);
				this.action = action;
				f_1990467 = true;
			}

			public void mouseClicked(int mouseX, int mouseY) {
				if (m_9491400(f_3511485, mouseX, mouseY)) {
					m_1301911(f_3511485.m_7555106());
					action.onPress(this);
				}
			}

			@Override
			public void m_1433237(int i, int j, int k) {

			}

			@Override
			public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY,
							   boolean hovered) {
				this.f_8532347 = y;
				m_5350167(f_3511485, mouseX, mouseY);
			}

			@Override
			public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
				if (m_9491400(f_3511485, mouseX, mouseY)) {
					m_1301911(f_3511485.m_7555106());
					action.onPress(this);
					return true;
				}
				return false;
			}

			@Override
			public void m_4703785(int i, int j, int k, int l, int m, int n) {

			}
		}
	}
}
