/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.Util;

public class ContextMenu {

	private final List<C_2348249> children;
	private int x;
	private int y;

	private int width, height = 0;
	private boolean rendering;

	protected ContextMenu(List<C_2348249> items) {
		children = items;
		int width = 0;
		int height = 0;
		for (C_2348249 d : children) {
			d.f_8532347 = height;
			height += 11;
			width = Math.max(width, d.m_8567079());
		}
		this.width = width;
		this.height = height;
	}

	public static Builder builder() {
		return new Builder();
	}

	public void addEntry(C_2348249 entry) {
		children.add(entry);
	}

	public void render(C_8105098 client, int mouseX, int mouseY) {
		if (!rendering) {
			y = mouseY;
			x = mouseX;
			rendering = true;
		}
		final int yStart = (int) Math.min(y + 2, Util.getWindow().m_6423725() - height - 2);
		final int xStart = (int) Math.min(x + 2, Util.getWindow().m_3624537() - width - 2);
		int y = yStart + 1;
		width = 0;
		for (C_2348249 d : children) {
			d.f_3923091 = (xStart + 1);
			d.f_8532347 = (y);
			y += 11;
			width = Math.max(width, d.m_8567079());
		}
		height = y;
		C_3754158.m_8373640();
		C_3754158.m_3172490(0, 0, 200);
		C_2691939.m_7865719(xStart, yStart, xStart + width + 1, y, 0xDD1E1F22);
		DrawUtil.outlineRect(xStart, yStart, width + 1, y - yStart + 1, -1);
		for (C_2348249 c : children) {
			c.m_5692328(width);
			c.m_5350167(client, mouseX, mouseY);
		}
		C_3754158.m_2041265();
	}

	public boolean mouseClicked(double mouseX, double mouseY, int button) {
		List<Pressable> stream = children.stream().filter(b -> b instanceof Pressable)
			.map(b -> (Pressable) b).toList();
		boolean clicked = false;
		for (Pressable c : stream) {
			clicked = c.onPress(mouseX, mouseY, button);
			if (clicked) {
				break;
			}
		}
		return clicked;
	}

	public boolean isMouseOver(double mouseX, double mouseY) {
		return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
	}

	public interface PressAction {
		void onPress(C_2348249 buttonWidget);
	}

	public static class Builder {

		private final List<C_2348249> elements = new ArrayList<>();

		public Builder() {

		}

		public Builder entry(String name, PressAction action) {
			elements.add(new ContextMenuEntryWithAction(C_3390001.m_2053009(name), action));
			return this;
		}

		public Builder entry(C_2348249 widget) {
			elements.add(widget);
			return this;
		}

		public Builder spacer() {
			elements.add(new ContextMenuEntry("-----"));
			return this;
		}

		public Builder title(String title) {
			elements.add(new ContextMenuEntry(title));
			return this;
		}

		public ContextMenu build() {
			return new ContextMenu(elements);
		}

	}

	public static class ContextMenuEntry extends C_2348249 implements Pressable {

		public ContextMenuEntry(String content) {
			super(0, 0, 0, C_8105098.m_0408063().f_0426313.m_0040387(content), 11, content);
		}

		@Override
		public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
			m_2717572(client.f_0426313, f_4865617, f_3923091 + m_8567079() / 2, f_8532347, 0xDDDDDD);
		}

		@Override
		public boolean onPress(double mouseX, double mouseY, int button) {
			return false;
		}
	}

	public static class ContextMenuEntryWithAction extends C_2348249 implements Pressable {

		final PressAction action;

		private final C_8105098 client = C_8105098.m_0408063();

		public ContextMenuEntryWithAction(String message, PressAction onPress) {
			super(0, 0, 0, C_8105098.m_0408063().f_0426313.m_0040387(message) + 4, 11, message);
			this.action = onPress;
		}

		@Override
		public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
			this.f_8690685 = mouseX >= this.f_3923091 && mouseY >= this.f_8532347 && mouseX < this.f_3923091 + this.f_9527567 && mouseY < this.f_8532347 + this.f_7845401;

			if (m_7131232()) {
				m_7865719(f_3923091, f_8532347, f_3923091 + m_8567079(), f_8532347 + f_7845401, 0x55ffffff);
			}

			C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
			int i = this.f_3831222 ? 16777215 : 10526880;
			drawScrollableText(C_8105098.m_0408063().f_0426313, 2, i);
		}

		protected void drawScrollableText(C_3831727 textRenderer, int xOffset, int color) {
			int x = this.f_3923091 + xOffset;
			int xEnd = this.f_3923091 + this.m_8567079() - xOffset;
			DrawUtil.drawScrollableText(textRenderer, f_4865617, x, this.f_8532347, xEnd, this.f_8532347 + f_7845401, color);
		}

		public boolean onPress(double mouseX, double mouseY, int button) {
			if (m_9491400(client, (int) mouseX, (int) mouseY) && button == 0) {
				m_1301911(client.m_7555106());
				action.onPress(this);
				return true;
			}
			return false;
		}
	}

	private interface Pressable {
		boolean onPress(double mouseX, double mouseY, int button);
	}
}
