/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.stream.Collectors;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_7724922;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.util.AlphabeticalComparator;

public class FriendsScreen extends C_3020744 {

	private final C_3020744 parent;

	private UserListWidget widget;

	private C_2348249 chatButton, removeButton, onlineTab, allTab, pendingTab, blockedTab;
	private C_2348249 denyButton, acceptButton, unblockButton, cancelButton;

	private Tab current = Tab.ONLINE;

	protected FriendsScreen(C_3020744 parent, Tab tab) {
		this(parent);
		current = tab;
	}

	public FriendsScreen(C_3020744 parent) {
		super();
		this.parent = parent;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		this.m_7817195();
		this.widget.m_9734698(mouseX, mouseY, delta);
		m_2717572(this.f_2020658, C_3390001.m_2053009("api.screen.friends"), this.f_5465691 / 2, 20, 16777215);
		super.m_7261014(mouseX, mouseY, delta);
	}

	@Override
	protected void m_6992336(char c, int i) {
		int j = this.widget.getSelected();
		C_1630332.C_8277969 entry = j < 0 ? null : this.widget.m_7118949(j);
		if (i == 63) {
			this.refresh();
		} else {
			if (j >= 0) {
				if (i == 200) {
					if (m_5142737()) {
						if (j > 0 && entry instanceof UserListWidget.UserListEntry) {
							this.select(this.widget.getSelected() - 1);
							this.widget.m_9909453(-this.widget.m_6703043());
						}
					} else if (j > 0) {
						this.select(this.widget.getSelected() - 1);
						this.widget.m_9909453(-this.widget.m_6703043());
						if (this.widget.m_7118949(this.widget.getSelected()) instanceof C_7724922) {
							if (this.widget.getSelected() > 0) {
								this.select(this.widget.m_3791031() - 1);
								this.widget.m_9909453(-this.widget.m_6703043());
							} else {
								this.select(-1);
							}
						}
					} else {
						this.select(-1);
					}
				} else if (i == 208) {
					if (m_5142737()) {
						this.select(j + 1);
						this.widget.m_9909453(this.widget.m_6703043());
					} else if (j < this.widget.m_3791031()) {
						this.select(this.widget.getSelected() + 1);
						this.widget.m_9909453(this.widget.m_6703043());
						if (this.widget.m_7118949(this.widget.getSelected()) instanceof C_7724922) {
							if (this.widget.getSelected() < this.widget.m_3791031() - 1) {
								this.select(this.widget.m_3791031() + 1);
								this.widget.m_9909453(this.widget.m_6703043());
							} else {
								this.select(-1);
							}
						}
					} else {
						this.select(-1);
					}
				} else if (i != 28 && i != 156) {
					super.m_6992336(c, i);
				} else {
					this.m_7971793(this.f_2213969.get(2));
				}
			} else {
				super.m_6992336(c, i);
			}
		}
	}

	private void refresh() {
		f_7153641.m_6408915(new FriendsScreen(parent));
	}

	public void select(int i) {
		this.widget.setSelected(i);
		this.updateButtonActivationStates();
	}

	public void openChat() {
		if (!chatButton.f_3831222) {
			return;
		}
		UserListWidget.UserListEntry entry = widget.getSelectedEntry();
		if (entry != null) {
			chatButton.f_3831222 = false;
			ChannelRequest.getOrCreateDM(entry.getUser())
				.thenAccept(c -> minecraft.submit(() -> minecraft.openScreen(new ChatScreen(this, c))));
		}
	}

	private void acceptRequest() {
		UserListWidget.UserListEntry entry = widget.getSelectedEntry();
		if (entry != null) {
			acceptButton.f_3831222 = false;
			FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> minecraft.submit(this::refresh));
		}
	}

	private void denyRequest() {
		UserListWidget.UserListEntry entry = widget.getSelectedEntry();
		if (entry != null) {
			denyButton.f_3831222 = false;
			FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> minecraft.submit(this::refresh));
		}
	}

	@Override
	protected void m_7362766(int i, int j, int k) {
		super.m_7362766(i, j, k);
		this.widget.m_7379893(i, j, k);
	}

	@Override
	protected void m_5308748(int i, int j, int k) {
		super.m_5308748(i, j, k);
		this.widget.m_9825864(i, j, k);
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		switch (buttonWidget.f_5920996) {
			case 0:
				this.f_7153641.m_6408915(this.parent);
				break;
			case 1:
				openChat();
				break;
			case 2:
				acceptRequest();
				break;
			case 3:
				denyRequest();
				break;
			case 4:
				UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
				if (entry != null) {
					removeButton.f_3831222 = false;
					FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> minecraft.submit(this::refresh));
				}
				break;
			case 5:
				f_7153641.m_6408915(new AddFriendScreen(this));
				break;
			case 6:
				f_7153641.m_6408915(new FriendsScreen(parent, Tab.ONLINE));
				break;
			case 7:
				f_7153641.m_6408915(new FriendsScreen(parent, Tab.ALL));
				break;
			case 8:
				f_7153641.m_6408915(new FriendsScreen(parent, Tab.PENDING));
				break;
			case 9:
				f_7153641.m_6408915(new FriendsScreen(parent, Tab.BLOCKED));
				break;
			case 10:
				buttonWidget.f_3831222 = false;
				FriendRequest.getInstance().unblockUser(widget.getSelectedEntry().getUser()).thenRun(() -> minecraft.submit(this::refresh));
				break;
			case 11:
				buttonWidget.f_3831222 = false;
				FriendRequest.getInstance().cancelFriendRequest(widget.getSelectedEntry().getUser()).thenRun(() -> minecraft.submit(this::refresh));
				break;
		}
	}

	@Override
	public void m_3593494() {
		widget = new UserListWidget(this, f_7153641, f_5465691, f_3080061, 32, f_3080061 - 64, 35);

		if (current == Tab.ALL || current == Tab.ONLINE) {
			FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> widget.setUsers(list.stream().filter(user -> {
				if (current == Tab.ONLINE) {
					return user.getStatus().isOnline();
				}
				return true;
			}).sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
		} else if (current == Tab.PENDING) {
			FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {

				con.getLeft().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, C_3390001.m_2053009("api.friends.pending.incoming"))));
				con.getRight().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, C_3390001.m_2053009("api.friends.pending.outgoing")).outgoing()));
			});
		} else if (current == Tab.BLOCKED) {
			FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> widget.setUsers(list.stream().sorted((u1, u2) ->
				new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
		}

		this.f_2213969.add(blockedTab = new C_2348249(9, this.f_5465691 / 2 + 24, this.f_3080061 - 52, 57, 20,
			C_3390001.m_2053009("api.friends.tab.blocked")));

		this.f_2213969.add(pendingTab = new C_2348249(8, this.f_5465691 / 2 - 34, this.f_3080061 - 52, 57, 20,
			C_3390001.m_2053009("api.friends.tab.pending")));

		this.f_2213969.add(allTab = new C_2348249(7, this.f_5465691 / 2 - 94, this.f_3080061 - 52, 57, 20,
			C_3390001.m_2053009("api.friends.tab.all")));

		this.f_2213969.add(onlineTab = new C_2348249(6, this.f_5465691 / 2 - 154, this.f_3080061 - 52, 57, 20,
			C_3390001.m_2053009("api.friends.tab.online")));

		this.f_2213969.add(new C_2348249(5, this.f_5465691 / 2 + 88, this.f_3080061 - 52, 66, 20,
			C_3390001.m_2053009("api.friends.add")));

		this.f_2213969.add(removeButton = new C_2348249(4, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20,
			C_3390001.m_2053009("api.friends.remove")));

		f_2213969.add(denyButton = new C_2348249(3, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 48, 20,
			C_3390001.m_2053009("api.friends.request.deny")));

		f_2213969.add(acceptButton = new C_2348249(2, this.f_5465691 / 2 + 2, this.f_3080061 - 28, 48, 20,
			C_3390001.m_2053009("api.friends.request.accept")));

		f_2213969.add(unblockButton = new C_2348249(10, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009("api.users.unblock")));
		f_2213969.add(cancelButton = new C_2348249(11, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009("gui.cancel")));

		this.f_2213969.add(chatButton = new C_2348249(1, this.f_5465691 / 2 - 154, this.f_3080061 - 28, 100, 20,
			C_3390001.m_2053009("api.friends.chat")));

		this.f_2213969.add(
			new C_2348249(0, this.f_5465691 / 2 + 4 + 50, this.f_3080061 - 28, 100, 20,
				C_3390001.m_2053009("gui.back")));
		updateButtonActivationStates();
	}

	private void updateButtonActivationStates() {
		UserListWidget.UserListEntry entry = widget.getSelectedEntry();
		chatButton.f_3831222 = entry != null && (current == Tab.ALL || current == Tab.ONLINE);

		removeButton.f_1990467 = true;
		unblockButton.f_3831222 = removeButton.f_3831222 = entry != null;
		denyButton.f_1990467 = false;
		acceptButton.f_1990467 = unblockButton.f_1990467 = cancelButton.f_1990467 = false;
		if (current == Tab.ONLINE) {
			onlineTab.f_3831222 = false;
			allTab.f_3831222 = pendingTab.f_3831222 = blockedTab.f_3831222 = true;
		} else if (current == Tab.ALL) {
			allTab.f_3831222 = false;
			onlineTab.f_3831222 = pendingTab.f_3831222 = blockedTab.f_3831222 = true;
		} else if (current == Tab.PENDING) {
			pendingTab.f_3831222 = false;
			onlineTab.f_3831222 = allTab.f_3831222 = blockedTab.f_3831222 = true;
			removeButton.f_1990467 = false;

			if (entry != null && entry.isOutgoingRequest()) {
				cancelButton.f_1990467 = true;
			} else {
				denyButton.f_1990467 = true;
				acceptButton.f_1990467 = true;
			}
			denyButton.f_3831222 = acceptButton.f_3831222 = entry != null;
		} else if (current == Tab.BLOCKED) {
			blockedTab.f_3831222 = false;
			onlineTab.f_3831222 = allTab.f_3831222 = pendingTab.f_3831222 = true;
			removeButton.f_1990467 = false;
			unblockButton.f_1990467 = true;
		}
	}

	@Override
	public void m_3356138() {
		super.m_3356138();
		this.widget.m_1002325();
	}

	public enum Tab {
		ONLINE,
		ALL,
		PENDING,
		BLOCKED
	}
}
