/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_4976084;
import io.github.axolotlclient.util.OSUtil;

public class PrivacyNoticeScreen extends C_3020744 {

	private static final URI TERMS_URI = URI.create(Constants.TERMS);

	private final C_3020744 parent;
	private final CompletableFuture<Boolean> accepted;
	private List<String> message;

	protected PrivacyNoticeScreen(C_3020744 parent, CompletableFuture<Boolean> accepted) {
		super();
		this.parent = parent;
		this.accepted = accepted;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		m_2717572(this.f_2020658, C_3390001.m_2053009("api.privacyNotice"), this.f_5465691 / 2, getTitleY(), -1);
		int k = 90;

		for (String string : this.message) {
			this.m_2717572(this.f_2020658, string, this.f_5465691 / 2, k, 16777215);
			k += this.f_2020658.f_6725889;
		}
		super.m_7261014(mouseX, mouseY, delta);
	}

	@Override
	public void m_3593494() {

		message = f_7153641.f_0426313.m_0466830(
			C_3390001.m_2053009("api.privacyNotice.description"), f_5465691 - 50);
		int y = C_4976084.m_1109374(this.getMessageY() + this.getMessagesHeight() + 20, this.f_3080061 / 6 + 96, this.f_3080061 - 24);
		this.addButtons(y);
	}

	private void addButtons(int y) {
		f_2213969.add(new C_2348249(1, f_5465691 / 2 - 50, y, 100, 20,
			C_3390001.m_2053009("api.privacyNotice.accept")));
		f_2213969.add(new C_2348249(0, f_5465691 / 2 + 55, y, 100, 20,
			C_3390001.m_2053009("api.privacyNotice.deny")));
		f_2213969.add(new C_2348249(2, f_5465691 / 2 - 155, y, 100, 20,
			C_3390001.m_2053009("api.privacyNotice.openPolicy")));
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			f_7153641.m_6408915(parent);
			APIOptions.getInstance().enabled.set(false);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.DENIED);
			accepted.complete(false);
		} else if (buttonWidget.f_5920996 == 1) {
			f_7153641.m_6408915(parent);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.ACCEPTED);
			accepted.complete(true);
		} else if (buttonWidget.f_5920996 == 2) {
			OSUtil.getOS().open(TERMS_URI);
		}
	}

	private int getTitleY() {
		int i = (this.f_3080061 - this.getMessagesHeight()) / 2;
		return C_4976084.m_1109374(i - 20 - 9, 10, 80);
	}

	private int getMessageY() {
		return this.getTitleY() + 20;
	}

	private int getMessagesHeight() {
		return this.message.size() * 9;
	}
}
