/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.function.Consumer;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class SimpleTextInputScreen extends C_3020744 {

	private final C_3020744 parent;
	private final String inputLabel;
	private final String title;
	private final Consumer<String> consumer;
	private C_2925725 input;
	private C_2348249 done;

	public SimpleTextInputScreen(C_3020744 parent, String title, String inputLabel, Consumer<String> consumer) {
		super();
		this.parent = parent;
		this.inputLabel = inputLabel;
		this.title = title;
		this.consumer = consumer;
	}

	@Override
	public void m_3593494() {
		input = new C_2925725(3, f_2020658, f_5465691 / 2 - 100, f_3080061 / 2 - 10, 200, 20);

		f_2213969.add(new C_2348249(0, f_5465691 / 2 - 155, f_3080061 - 50, 150, 20, C_3390001.m_2053009("gui.cancel")));
		f_2213969.add(done = new C_2348249(1, f_5465691 / 2 + 5, f_3080061 - 50, 150, 20, C_3390001.m_2053009("gui.done")));
		done.f_3831222 = false;
	}

	@Override
	public void m_2450377() {
		input.m_0296611();
		done.f_3831222 = !input.m_4862541().isBlank();
	}

	@Override
	public void m_7261014(int i, int j, float f) {
		m_7817195();
		super.m_7261014(i, j, f);
		f_2020658.m_1950885(inputLabel, f_5465691 / 2F - 100, f_3080061 / 2f - 20, -1);
		m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 20, 16777215);
		input.m_1620442();
	}

	@Override
	public void m_7362766(int mouseX, int mouseY, int button) {
		super.m_7362766(mouseX, mouseY, button);
		input.m_1129375(mouseX, mouseY, button);
	}

	@Override
	protected void m_6992336(char c, int i) {
		input.m_1973329(c, i);
		super.m_6992336(c, i);
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		switch (buttonWidget.f_5920996) {
			case 0:
				f_7153641.m_6408915(parent);
				break;
			case 1:
				if (!input.m_4862541().isBlank()) {
					consumer.accept(input.m_4862541());
				}
				f_7153641.m_6408915(parent);
				break;
		}
	}
}
