/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_2160183;
import net.minecraft.unmapped.C_2670477;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8938952;
import net.minecraft.unmapped.C_9590849;
import com.google.gson.JsonObject;
import io.github.axolotlclient.api.e4mc.E4mcStatusProvider;
import io.github.axolotlclient.api.requests.StatusUpdate;
import io.github.axolotlclient.api.util.StatusUpdateProvider;
import io.github.axolotlclient.modules.hypixel.HypixelMods;

public class StatusUpdateProviderImpl implements StatusUpdateProvider {

	@Override
	public void initialize() {
	}

	@Override
	public Request getStatus() {
		C_1533205 entry = C_8105098.m_0408063().m_1862495();
		if (entry != null) {

			if (!entry.m_1893727()) {
				Optional<StatusUpdate.SupportedServer> optional = Arrays.stream(StatusUpdate.SupportedServer.values()).filter(s -> s.getAddress().matcher(entry.f_7619058).matches()).findFirst();
				if (optional.isPresent()) {
					StatusUpdate.SupportedServer server = optional.get();
					if (server.equals(StatusUpdate.SupportedServer.HYPIXEL)) {
						return HypixelMods.getInstance().getStatus();
					}
				}
				return StatusUpdate.inGameServer(entry.f_4296074, entry.f_7619058);
			}
			return StatusUpdate.inGameUnknown(entry.f_4296074);
		} else if (C_8105098.m_0408063().m_9805322()) {
			var e4mcStatus = E4mcStatusProvider.getStatusDescription();
			if (e4mcStatus != null) {
				return StatusUpdate.e4mcStatusUpdate(e4mcStatus);
			}
			return StatusUpdate.inGameUnknown(C_8105098.m_0408063().m_4351464().m_0524218());
		}
		C_3020744 current = C_8105098.m_0408063().f_0723335;
		if (current instanceof C_8938952) {
			return StatusUpdate.online(StatusUpdate.MenuId.MAIN_MENU);
		} else if (current instanceof C_2160183) {
			return StatusUpdate.online(StatusUpdate.MenuId.SERVER_LIST);
		} else if (current != null) {
			return StatusUpdate.online(StatusUpdate.MenuId.SETTINGS);
		}
		return null;
	}

	private String getOrEmpty(JsonObject object, String name) {
		return object.has(name) ? object.get(name).getAsString() : "";
	}

	private C_2670477.C_3802308 getGameMode(C_9590849 entity) {
		return C_8105098.m_0408063().m_3332347().m_2405262(entity.m_2013188()).m_8611410();
	}
}
