/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import lombok.Getter;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class UserListWidget extends C_1630332 {

	private final FriendsScreen screen;
	private final List<UserListEntry> entries = new ArrayList<>();
	private int selectedEntry = -1;

	public UserListWidget(FriendsScreen screen, C_8105098 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, height, top, bottom, entryHeight);
		this.screen = screen;
	}

	public void setUsers(List<User> users) {
		users.forEach(user -> addEntry(new UserListEntry(user)));
	}

	public void addEntry(UserListEntry entry) {
		entries.add(entry.init(screen));
	}

	@Override
	protected int m_3791031() {
		return entries.size();
	}

	@Override
	public int m_6519286() {
		return super.m_6519286() + 85;
	}

	@Override
	protected int m_3021017() {
		return super.m_3021017() + 30;
	}

	@Override
	protected boolean m_5993229(int i) {
		return i == this.selectedEntry;
	}

	@Override
	public C_8277969 m_7118949(int i) {
		return entries.get(i);
	}

	public UserListEntry getSelectedEntry() {
		if (getSelected() < 0) {
			return null;
		}
		return entries.get(getSelected());
	}

	public int getSelected() {
		return this.selectedEntry;
	}

	public void setSelected(int i) {
		this.selectedEntry = i;
	}

	public static class UserListEntry extends C_2691939 implements C_1630332.C_8277969 {

		@Getter
		private final User user;
		private final C_8105098 client;
		private long time;
		private String note;
		private FriendsScreen screen;

		@Getter
		private boolean outgoingRequest;

		public UserListEntry(User user, String note) {
			this(user);
			this.note = C_1945050.f_8012292 + note;
		}

		public UserListEntry(User user) {
			this.client = C_8105098.m_0408063();
			this.user = user;
		}

		public UserListEntry init(FriendsScreen screen) {
			this.screen = screen;
			return this;
		}

		public UserListEntry outgoing() {
			outgoingRequest = true;
			return this;
		}

		@Override
		public void m_1433237(int i, int j, int k) {

		}

		@Override
		public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
			if (user.isSystem()) {
				String fronters = user.getSystem().getFronters().stream()
					.map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/"));
				String tag = C_1945050.f_8012292 + C_1945050.f_7540461.toString() + "(" + user.getSystem().getName() + "/" + user.getName() + ")";
				client.f_0426313.m_4683674(fronters + " " + tag, x + 3, y + 1, -1);
			} else {
				client.f_0426313.m_4683674(user.getName(), x + 3 + 33, y + 1, -1);
			}

			if (user.getStatus().isOnline() && user.getStatus().getActivity() != null) {
				client.f_0426313.m_4683674(user.getStatus().getTitle(), x + 3 + 33, y + 12, 8421504);
				client.f_0426313.m_4683674(user.getStatus().getDescription(), x + 3 + 40, y + 23, 8421504);
			} else if (user.getStatus().getLastOnline() != null) {
				client.f_0426313.m_4683674(user.getStatus().getLastOnline(), x + 3 + 33, y + 12, 8421504);
			}

			if (note != null) {
				client.f_0426313.m_4683674(note, x + entryWidth - client.f_0426313.m_0040387(note) - 4, y + entryHeight - 10, 8421504);
			}

			C_3754158.m_3323122(1, 1, 1, 1);
			client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(user.getUuid(), user.getName()));
			C_3754158.m_9671730();
			m_4673442(x - 1, y - 1, 8, 8, 8, 8, 33, 33, 64, 64);
			m_4673442(x - 1, y - 1, 40, 8, 8, 8, 33, 33, 64, 64);
			C_3754158.m_5313301();
		}

		@Override
		public boolean m_3739705(int i, int j, int k, int l, int m, int n) {
			this.screen.select(i);
			if (C_8105098.m_6224581() - this.time < 250L && client.f_4601986 == null) {
				screen.openChat();
			}

			this.time = C_8105098.m_6224581();
			return false;
		}

		@Override
		public void m_4703785(int i, int j, int k, int l, int m, int n) {

		}
	}
}
