/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import io.github.axolotlclient.api.requests.AccountUsernameRequest;
import io.github.axolotlclient.api.types.User;

public class UsernameManagementScreen extends C_3020744 {

	private final C_3020744 parent;
	private UsernameListWidget widget;
	private final String title = C_3390001.m_2053009("api.account.usernames");

	public UsernameManagementScreen(C_3020744 parent) {
		super();
		this.parent = parent;
	}

	@Override
	public void m_3593494() {
		if (API.getInstance().isAuthenticated()) {
			widget = new UsernameListWidget(API.getInstance().getSelf().getPreviousUsernames());
		} else {
			widget = new UsernameListWidget(Collections.emptyList());
		}

		f_2213969.add(new C_2348249(0, f_5465691 / 2 - 75, f_3080061 - 25 - 20, 150, 20, C_3390001.m_2053009("gui.back")));
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			f_7153641.m_6408915(parent);
		}
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		widget.m_9734698(mouseX, mouseY, delta);
		super.m_7261014(mouseX, mouseY, delta);
		f_2020658.m_1950885(title, f_5465691 / 2f - f_2020658.m_0040387(title) / 2f, 25, -1);
	}

	@Override
	public void m_3356138() {
		super.m_3356138();
		widget.m_1002325();
	}

	@Override
	protected void m_7362766(int i, int j, int k) {
		if (!widget.m_7379893(i, j, k)) {
			super.m_7362766(i, j, k);
		}
	}

	@Override
	protected void m_5308748(int i, int j, int k) {
		if (!widget.m_9825864(i, j, k)) {
			super.m_5308748(i, j, k);
		}
	}

	private class UsernameListWidget extends C_1630332 {

		private final List<UsernameListEntry> entries = new ArrayList<>();

		public UsernameListWidget(List<User.OldUsername> names) {
			super(UsernameManagementScreen.this.f_7153641, UsernameManagementScreen.this.f_5465691, UsernameManagementScreen.this.f_3080061, 45, UsernameManagementScreen.this.f_3080061 - 55, 20);

			names.forEach(n -> entries.add(new UsernameListEntry(n)));
		}

		@Override
		protected int m_3021017() {
			return (f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2) + m_6519286() + 10;
		}

		@Override
		public int m_6519286() {
			return 310;
		}

		@Override
		public C_8277969 m_7118949(int i) {
			return entries.get(i);
		}

		@Override
		protected int m_3791031() {
			return entries.size();
		}

		private class UsernameListEntry implements C_8277969 {

			private final C_2348249 visibility;
			private final C_2348249 delete;
			private final User.OldUsername name;

			public UsernameListEntry(User.OldUsername name) {
				visibility = new C_2348249(1, 0, 0, 100, 20, C_3390001.m_2053009("api.account.usernames.public", name.isPub()));
				delete = new C_2348249(1, 0, 0, 100, 20, C_3390001.m_2053009("api.account.usernames.delete"));
				this.name = name;
			}

			@Override
			public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
				int deleteX = UsernameListWidget.this.m_3021017() - delete.m_8567079() - 10;
				delete.f_3923091 = deleteX;
				delete.f_8532347 = y - 2;
				visibility.f_3923091 = deleteX - visibility.m_8567079() - 5;
				visibility.f_8532347 = y - 2;
				delete.m_5350167(f_3511485, mouseX, mouseY);
				visibility.m_5350167(f_3511485, mouseX, mouseY);
				f_2020658.m_1950885(name.getName(), x, y + entryHeight / 2f - 9 / 2f, -1);
			}

			@Override
			public void m_1433237(int i, int j, int k) {

			}

			@Override
			public boolean m_3739705(int i, int mouseX, int mouseY, int l, int m, int n) {
				if (delete.m_9491400(f_3511485, mouseX, mouseY)) {
					f_3511485.m_6408915(new C_1441789((b, un) -> {
						if (b) {
							AccountUsernameRequest.delete(name.getName()).thenRun(() ->
								UsernameListWidget.this.entries.remove(this));
						}
						f_3511485.m_6408915(UsernameManagementScreen.this);
					}, C_3390001.m_2053009("api.account.confirm_deletion"),
						C_3390001.m_2053009("api.account.usernames.delete.desc"), 0));
					return true;
				} else if (visibility.m_9491400(f_3511485, mouseX, mouseY)) {
					name.setPub(!name.isPub());
					visibility.f_4865617 = C_3390001.m_2053009("api.account.usernames.public", name.isPub());
					AccountUsernameRequest.post(name.getName(), name.isPub());
					return true;
				}
				return false;
			}

			@Override
			public void m_4703785(int i, int j, int k, int l, int m, int n) {

			}
		}
	}
}
