/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.ChannelInvite;
import io.github.axolotlclient.api.util.UUIDHelper;

public class ChannelInvitesScreen extends C_3020744 {
	private final C_3020744 parent;
	private C_2348249 acceptButton;
	private C_2348249 denyButton;
	private InvitesListWidget invites;
	private final String title;

	public ChannelInvitesScreen(C_3020744 parent) {
		super();
		this.title = C_3390001.m_2053009("api.channels.invites");
		this.parent = parent;
	}

	@Override
	public void m_3593494() {
		invites = new InvitesListWidget(f_7153641, f_3080061, 33, f_5465691, f_3080061 - 88, 25);


		f_2213969.add(acceptButton = new C_2348249(1, f_5465691 / 2 - 75, f_3080061 - 55 / 2 - 2 - 20, 73, 20, C_3390001.m_2053009("api.channels.invite.accept")));
		f_2213969.add(denyButton = new C_2348249(2, f_5465691 / 2 + 2, f_3080061 - 55 / 2 - 2 - 20, 73, 20, C_3390001.m_2053009("api.channels.invite.ignore")));
		f_2213969.add(new C_2348249(0, f_5465691 / 2 - 75, f_3080061 - 55 / 2 + 2, 150, 20, C_3390001.m_2053009("gui.back")));

		updateButtons();
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		invites.m_9734698(mouseX, mouseY, delta);
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, title, f_5465691 / 2, 33 / 2, -1);
	}

	@Override
	protected void m_7362766(int i, int j, int k) {
		invites.m_7379893(i, j, k);
		super.m_7362766(i, j, k);
	}

	@Override
	public void m_3356138() {
		invites.m_1002325();
		super.m_3356138();
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			f_7153641.m_6408915(parent);
		} else if (buttonWidget.f_5920996 == 1) {
			if (invites.getSelected() != null) {
				buttonWidget.f_3831222 = false;
				ChannelRequest.acceptChannelInvite(invites.getSelected().invite).thenRun(() -> f_7153641.m_2167033(() -> m_0116202(f_7153641, f_5465691, f_3080061)));
			}
		} else if (buttonWidget.f_5920996 == 2) {
			if (invites.getSelected() != null) {
				buttonWidget.f_3831222 = false;
				ChannelRequest.ignoreChannelInvite(invites.getSelected().invite).thenRun(() -> f_7153641.m_2167033(() -> m_0116202(f_7153641, f_5465691, f_3080061)));
			}
		}
	}

	private void updateButtons() {
		denyButton.f_3831222 = acceptButton.f_3831222 = invites.getSelected() != null;
	}

	private class InvitesListWidget extends C_1630332 {

		private final List<InvitesListEntry> entries = new ArrayList<>();
		private int selectedEntry = -1;

		public InvitesListWidget(C_8105098 client, int screenHeight, int y, int width, int height, int entryHeight) {
			super(client, width, screenHeight, y, y + height, entryHeight);
			ChannelRequest.getChannelInvites().thenAccept(list ->
				list.stream().map(InvitesListEntry::new).forEach(entries::add));
		}

		@Override
		public boolean m_7379893(int mouseX, int mouseY, int button) {
			boolean bl = super.m_7379893(mouseX, mouseY, button);
			updateButtons();
			return bl;
		}

		@Override
		public C_8277969 m_7118949(int i) {
			return entries.get(i);
		}

		@Override
		protected int m_3791031() {
			return entries.size();
		}

		public InvitesListEntry getSelected() {
			if (selectedEntry >= 0) {
				return entries.get(selectedEntry);
			}
			return null;
		}

		private class InvitesListEntry implements C_8277969 {

			private final ChannelInvite invite;
			private final CompletableFuture<String> fromName;

			public InvitesListEntry(ChannelInvite invite) {
				this.invite = invite;
				this.fromName = UUIDHelper.tryGetUsernameAsync(invite.fromUuid());
			}

			@Override
			public void m_1433237(int i, int j, int k) {

			}

			@Override
			public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovere) {
				m_6649515(f_2020658, C_3390001.m_2053009("api.channels.invite.name", invite.channelName()), x + 2, y + 2, -1);
				if (fromName.isDone()) {
					m_6649515(f_2020658, C_1945050.f_8012292 + C_3390001.m_2053009("api.channels.invite.from", fromName.join()), x + 15, y + entryHeight - f_2020658.f_6725889 - 1, 0x808080);
				}
			}

			@Override
			public boolean m_3739705(int i, int j, int k, int l, int m, int n) {
				selectedEntry = i;
				return true;
			}

			@Override
			public void m_4703785(int i, int j, int k, int l, int m, int n) {

			}
		}
	}
}
