/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.DoubleOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.SliderWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Persistence;
import io.github.axolotlclient.api.util.UUIDHelper;

public class ChannelSettingsScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {
	private final C_3020744 parent;
	private final Channel channel;
	private String tooltip;
	private Element tooltipElement;

	protected ChannelSettingsScreen(C_3020744 parent, Channel channel) {
		super(C_3390001.m_2053009("api.channel.configure"));
		this.parent = parent;
		this.channel = channel;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, title, f_5465691 / 2, 36 / 2 - f_2020658.f_6725889 / 2, -1);

		if (tooltip != null) {
			tooltipElement = hoveredElement(mouseX, mouseY).orElse(null);
			m_9128141(f_2020658.m_0466830(tooltip, 170), mouseX, mouseY);
		}
		if (hoveredElement(mouseX, mouseY).map(e -> e != tooltipElement).orElse(true)) {
			tooltip = null;
		}
	}

	@Override
	public void m_3593494() {
		int leftColX = f_5465691 / 2 - 4 - 150;
		int leftColYStep = f_2020658.f_6725889 + 20 - f_2020658.f_6725889 + 8 - 5 + 5;
		int leftColY = 36 + 5 + 30;
		int rightColX = f_5465691 / 2 + 4;
		int rightColYStep = 20 + 8;
		int rightColY = 36 + 30;

		var nameField = new TextFieldWidget(f_2020658, rightColX, rightColY, 150, 20, "");
		nameField.setText(channel.getRealName());
		addDrawableChild(text("api.chat.groups.name", leftColX, leftColY));
		addDrawableChild(nameField);
		rightColY += rightColYStep;
		leftColY += leftColYStep;

		AtomicReference<Supplier<Integer>> count = new AtomicReference<>();
		AtomicReference<Supplier<Long>> duration = new AtomicReference<>();

		AtomicReference<Consumer<Boolean>> countDisabler = new AtomicReference<>();
		AtomicReference<Consumer<Boolean>> durationDisabler = new AtomicReference<>();
		var persistence = new VanillaButtonWidget(rightColX, rightColY, 150, 20, "", a -> {
		}) {
			final Persistence.Type[] persistenceValues = Persistence.Type.values();
			int current = channel.getPersistence().type().ordinal();

			@Override
			public void drawWidget(int mouseX, int mouseY, float delta) {
				setMessage(C_3390001.m_2053009("api.chat.persistence." + persistenceValues[current].getId()));
				super.drawWidget(mouseX, mouseY, delta);
			}

			@Override
			public void onPress() {
				current++;
				if (current >= persistenceValues.length) {
					current = 0;
				}
				Persistence.Type object = persistenceValues[current];
				switch (object) {
					case COUNT_DURATION -> {
						countDisabler.get().accept(true);
						countDisabler.get().accept(true);
					}
					case DURATION -> {
						durationDisabler.get().accept(true);
						countDisabler.get().accept(false);
					}
					case COUNT -> {
						countDisabler.get().accept(true);
						durationDisabler.get().accept(false);
					}
					case CHANNEL -> {
						countDisabler.get().accept(false);
						durationDisabler.get().accept(false);
					}
				}
			}

			public Persistence.Type getValue() {
				return persistenceValues[current];
			}
		};
		rightColY += rightColYStep;
		addDrawableChild(text("api.chat.groups.persistence", leftColX, leftColY));
		leftColY += leftColYStep;
		addDrawableChild(persistence);
		addDrawableChild(text("api.chat.groups.persistence.count", "api.chat.groups.persistence.count.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		countDisabler.set(sliderAssembly(rightColX, rightColY, val -> (int) (val * 100d), count::set, channel.getPersistence().count() / 100d));
		rightColY += rightColYStep;
		addDrawableChild(text("api.chat.groups.persistence.duration", "api.chat.groups.persistence.duration.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		durationDisabler.set(sliderAssembly(rightColX, rightColY, val -> (long) (val * 100d), duration::set, channel.getPersistence().duration() / 100d));
		rightColY += rightColYStep;
		countDisabler.get().accept(false);
		durationDisabler.get().accept(false);

		var namesInput = addDrawableChild(new TextFieldWidget(f_2020658, rightColX, rightColY, 150, 20, ""));
		addDrawableChild(text("api.chat.groups.participants", leftColX, leftColY));

		int footerY = f_3080061 - 36 / 2 - 20 / 2;
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 150 - 4, footerY, 150, 20, C_3390001.m_2053009("gui.cancel"), widget -> f_7153641.m_6408915(parent)));
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 4, footerY, 150, 20, C_3390001.m_2053009("gui.done"), widget -> {
			ChannelRequest.updateChannel(channel.getId(), nameField.getText(),
				Persistence.of(persistence.getValue(), count.get().get(), duration.get().get()),
				Arrays.stream(namesInput.getText().split(",")).filter(s -> !s.isEmpty()).map(UUIDHelper::ensureUuid).toArray(String[]::new));
			f_7153641.m_6408915(parent);
		}));
	}

	private <T> Consumer<Boolean> sliderAssembly(int x, int y, Function<Double, T> valueFunc, Consumer<Supplier<T>> value, double initialValue) {

		AtomicReference<T> currentVal = new AtomicReference<>();
		DoubleOption opt = new DoubleOption("", initialValue, d -> currentVal.set(valueFunc.apply(d)), 0d, 1d);
		var slider = new SliderWidget<>(x, y, 128, 20, opt);
		opt.set(initialValue);
		value.accept(currentVal::get);
		var text = new TextFieldWidget(f_2020658, x, y, 128, 20, "");
		var textButton = new ButtonWidget(x + 130, y, 20, 20, C_3390001.m_2053009("slider.text_input"), w -> {
			if (slider.visible) {
				text.setX(slider.getX());
				text.setY(slider.getY());
				text.setWidth(slider.getWidth());
				text.setText(String.valueOf(currentVal.get()));
			} else {
				try {
					opt.set(Double.parseDouble(text.getText()));
				} catch (Exception ignored) {
				}
			}
			slider.visible = !slider.visible;
			text.visible = !slider.visible;
		}) {
			@Override
			public void drawWidget(int mouseX, int mouseY, float delta) {
				this.client.m_1218956().m_5325521(WIDGETS_LOCATION);
				C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
				int k = this.active ? (this.hovered ? 2 : 1) : 0;
				C_3754158.m_9671730();
				C_3754158.m_0833259(770, 771, 1, 0);
				C_3754158.m_2076358(770, 771);
				this.m_4354119(this.getX(), this.getY(), 0, 46 + k * 20, this.getWidth() / 2, this.getHeight());
				this.m_4354119(this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, 46 + k * 20, this.getWidth() / 2, this.getHeight());
				client.m_1218956().m_5325521(new C_0561170("axolotlclient", "textures/gui/sprites/cursor.png"));
				m_4673442(getX() + getWidth() / 2 - 4, getY() + getHeight() / 2 - 4,
					8, 8, 8, 8, 8, 8, 8, 8);

			}
		};
		text.visible = false;
		addDrawableChild(text);
		addDrawableChild(textButton);
		addDrawableChild(slider);
		return val -> slider.active = textButton.active = text.active = val;
	}

	private ClickableWidget text(String translationKey, int x, int y) {
		String text = C_3390001.m_2053009(translationKey);
		return new ClickableWidget(x, y, 150, f_2020658.f_6725889, text) {

			@Override
			public void render(int mouseX, int mouseY, float delta) {
				DrawUtil.drawScrollingText(getMessage(), getX(), getY(), getWidth(), getHeight(), Colors.WHITE);
			}

			public boolean mouseClicked(double mouseX, double mouseY, int button) {
				return false;
			}
		};
	}

	private ClickableWidget text(String translationKey, String tooltipKey, int x, int y) {
		String text = C_3390001.m_2053009(translationKey);
		return new ClickableWidget(x, y, 150, f_2020658.f_6725889, text) {

			@Override
			public void drawWidget(int mouseX, int mouseY, float delta) {
				DrawUtil.drawScrollingText(getMessage(), getX(), getY(), getWidth(), getHeight(), Colors.WHITE);
				if (isHovered()) {
					ChannelSettingsScreen.this.tooltip = C_3390001.m_2053009(tooltipKey);
				}
			}

			@Override
			public boolean mouseClicked(double mouseX, double mouseY, int button) {
				return false;
			}
		};
	}
}
