/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class ChatListScreen extends C_3020744 implements ContextMenuScreen {

	private final C_3020744 parent;
	private final ContextMenuContainer container;
	private ChatListWidget dms;
	private ChatListWidget groups;

	public ChatListScreen(C_3020744 parent) {
		super();
		this.parent = parent;
		container = new ContextMenuContainer();
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_0157418(0);
		dms.m_9734698(mouseX, mouseY, delta);
		groups.m_9734698(mouseX, mouseY, delta);
		super.m_7261014(mouseX, mouseY, delta);
		container.render(f_7153641, mouseX, mouseY);

		m_2717572(f_7153641.f_0426313, C_3390001.m_2053009("api.chats"), f_5465691 / 2, 20, -1);
		m_2717572(f_7153641.f_0426313, C_3390001.m_2053009("api.chat.dms"), f_5465691 / 2 + 80, 40, -1);
		m_2717572(f_7153641.f_0426313, C_3390001.m_2053009("api.chat.groups"), f_5465691 / 2 - 80, 40, -1);
	}

	@Override
	public void m_3593494() {
		groups = new ChatListWidget(this, f_5465691, f_3080061, f_5465691 / 2 - 155, 55, 150, f_3080061 - 105, c -> !c.isDM());
		dms = new ChatListWidget(this, f_5465691, f_3080061, f_5465691 / 2 + 5, 55, 150, f_3080061 - 105, Channel::isDM);

		f_2213969.add(new C_2348249(0, this.f_5465691 / 2 + 5, this.f_3080061 - 40, 150, 20, C_3390001.m_2053009("gui.back")));
		f_2213969.add(new C_2348249(1, this.f_5465691 / 2 - 155, this.f_3080061 - 40, 150, 20,
			C_3390001.m_2053009("api.chat.groups.create")));
		ChannelRequest.getChannelList().thenAccept(list -> {
			groups.addChannels(list);
			dms.addChannels(list);
		});
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return container;
	}

	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			f_7153641.m_6408915(parent);
		} else if (buttonWidget.f_5920996 == 1) {
			f_7153641.m_6408915(new CreateChannelScreen(this));
		}
	}

	@Override
	public C_3020744 getParent() {
		return parent;
	}

	protected void m_7362766(int i, int j, int k) {
		if (container.mouseClicked(i, j, k)) {
			return;
		}
		super.m_7362766(i, j, k);
		dms.m_7379893(i, j, k);
		groups.m_7379893(i, j, k);
	}

	@Override
	public C_3020744 getSelf() {
		return this;
	}

	public void m_3356138() {
		super.m_3356138();
		dms.m_1002325();
		groups.m_1002325();
	}
}
