/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.modules.hud.util.DrawUtil;

public class ChatListWidget extends C_1630332 {

	protected final ContextMenuScreen screen;
	private final Predicate<Channel> predicate;

	private final List<ChatListEntry> entries = new ArrayList<>();

	public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height, Predicate<Channel> filter) {
		super(C_8105098.m_0408063(), width, height, y, y + height, 25);
		m_3867153(x);
		this.screen = screen;
		this.predicate = filter;
	}

	public void addChannels(List<Channel> channels) {
		channels.stream().filter(predicate).sorted().forEach(c -> entries.add(0, new ChatListEntry(c)));
		f_1867063 = 0;
	}

	public void setActiveChannel(Channel channel) {
		entries.stream().filter(e -> e.channel.equals(channel))
			.findFirst().ifPresent(c -> c.widget.f_3831222 = false);
	}

	@Override
	public int m_6519286() {
		return f_2695432 - 8;
	}

	public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height) {
		this(screen, screenWidth, screenHeight, x, y, width, height, c -> true);
	}

	@Override
	protected int m_3021017() {
		return this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2 + f_2695432 - 8;
	}

	@Override
	protected void m_2972483(int i, int j, int k, int l) {
		DrawUtil.enableScissor(f_8129586, f_9975269, f_7901480, f_9145833);
		super.m_2972483(i, j, k, l);
		DrawUtil.disableScissor();
	}

	@Override
	public C_8277969 m_7118949(int i) {
		return entries.get(i);
	}

	@Override
	protected int m_3791031() {
		return entries.size();
	}

	public class ChatListEntry implements C_8277969 {

		private final Channel channel;
		private final C_2348249 widget;

		public ChatListEntry(Channel channel) {
			this.channel = channel;
			widget = new C_2348249(-1, 0, 0, m_6519286(), 20, channel.getName()) {
				@Override
				public void m_2717572(C_3831727 textRenderer, String string, int i, int j, int k) {
					DrawUtil.drawScrollableText(textRenderer, string, f_3923091 + 2, f_8532347, f_3923091 + f_9527567 - 2, f_8532347 + f_7845401, k);
				}
			};
		}

		@Override
		public void m_1433237(int i, int j, int k) {

		}

		@Override
		public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
			widget.f_3923091 = (x);
			widget.f_8532347 = (y);
			widget.m_5350167(f_3511485, mouseX, mouseY);
		}

		@Override
		public boolean m_3739705(int index, int mouseX, int mouseY, int button, int m, int n) {
			if (widget.m_9491400(f_3511485, mouseX, mouseY)) {
				if (button == 0) {
					f_3511485.m_6408915(new ChatScreen(screen.getParent(), channel));
					return true;
				} else if (button == 1) {
					ContextMenu.Builder builder = ContextMenu.builder()
						.title(channel.getName())
						.spacer()
						.entry(C_3390001.m_2053009("api.channel.configure"), w -> f_3511485.m_6408915(new ChannelSettingsScreen(ChatListWidget.this.screen.getSelf(), channel)))
						.spacer();
					if (channel.getOwner().equals(API.getInstance().getSelf())) {
						builder.entry(C_3390001.m_2053009("api.channel.delete"), w -> f_3511485.m_6408915(new C_1441789((bl, i) -> {
							if (bl) {
								ChannelRequest.leaveOrDeleteChannel(channel).whenComplete((o, throwable) -> f_3511485.m_2167033(() -> f_3511485.m_6408915(screen.getSelf())));
							}
						}, C_3390001.m_2053009("api.channels.delete.confirm"), C_3390001.m_2053009("api.channels.delete.confirm.desc", channel.getName()), 0)));
					} else {
						builder.entry(C_3390001.m_2053009("api.channel.leave"), w -> f_3511485.m_6408915(new C_1441789((bl, i) -> {
							if (bl) {
								ChannelRequest.leaveOrDeleteChannel(channel).whenComplete((o, throwable) -> f_3511485.m_2167033(() -> f_3511485.m_6408915(screen.getSelf())));
							}
						}, C_3390001.m_2053009("api.channels.leave.confirm"), channel.getOwner().getRelation() == Relation.FRIEND ?
							C_3390001.m_2053009("api.channels.leave.confirm.desc_add", channel.getName()) :
							C_3390001.m_2053009("api.channels.leave.confirm.desc_invite", channel.getName()), 0)));
					}
					ChatListWidget.this.screen.setContextMenu(builder.build());
					return true;
				}
			}
			return false;
		}

		@Override
		public void m_4703785(int i, int j, int k, int l, int m, int n) {

		}
	}
}
