/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import org.lwjgl.input.Keyboard;

public class ChatScreen extends C_3020744 implements ContextMenuScreen {

	private final Channel channel;
	private final C_3020744 parent;
	private final ContextMenuContainer contextMenu = new ContextMenuContainer();
	private ChatWidget widget;
	private ChatListWidget chatListWidget;
	private ChatUserListWidget users;
	private C_2925725 input;

	public ChatScreen(C_3020744 parent, Channel channel) {
		super();
		this.channel = channel;
		this.parent = parent;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_0157418(0);

		if (users != null) {
			users.m_9734698(mouseX, mouseY, delta);
		}

		chatListWidget.m_9734698(mouseX, mouseY, delta);
		widget.m_9734698(mouseX, mouseY, delta);
		input.m_1620442();

		super.m_7261014(mouseX, mouseY, delta);

		m_2717572(this.f_2020658, channel.getName(), this.f_5465691 / 2, 20, 16777215);

		contextMenu.render(f_7153641, mouseX, mouseY);
	}

	@Override
	public void m_3593494() {
		chatListWidget = new ChatListWidget(this, f_5465691, f_3080061, 0, 30, 55, f_3080061 - 90);
		ChannelRequest.getChannelList().thenAccept(chatListWidget::addChannels).thenRun(() -> chatListWidget.setActiveChannel(channel));

		widget = new ChatWidget(channel, 65, 30, f_5465691 - 155, f_3080061 - 90, this);

		users = new ChatUserListWidget(this, f_7153641, 80, f_3080061 - 20, 30, f_3080061 - 60, 25);
		users.m_3867153(f_5465691 - 80);
		users.setUsers(channel.getAllUsers(), channel);

		input = new C_2925725(5, f_7153641.f_0426313, f_5465691 / 2 - 150, f_3080061 - 50,
			300, 20) {

			@Override
			public boolean m_1973329(char c, int i) {
				if (i == Keyboard.KEY_RETURN && !m_4862541().isEmpty()) {
					ChatHandler.getInstance().sendMessage(channel, m_4862541());
					m_1464552("");
					return true;
				}
				return super.m_1973329(c, i);
			}

			@Override
			public void m_1620442() {
				super.m_1620442();
				if (m_4862541().isEmpty()) {
					m_6649515(f_2020658, C_3390001.m_2053009(channel.isDM() ? "api.chat.messageUser" : "api.chat.messageGroup", channel.getName()),
						f_2565579 + 2, f_8286097 + 6, -8355712);
				}
			}
		};
		input.m_1954651(1024);

		if (channel.getOwner().equals(API.getInstance().getSelf())) {
			f_2213969.add(new C_2348249(2, f_5465691 - 60, 5, 50, 20, C_3390001.m_2053009("api.channel.configure")) {
				@Override
				public void m_2717572(C_3831727 textRenderer, String string, int i, int j, int k) {
					DrawUtil.drawScrollableText(textRenderer, string, f_3923091 + 2, f_8532347, f_3923091 + f_9527567 - 2, f_8532347 + f_7845401, k);
				}
			});
		}

		this.f_2213969.add(new C_2348249(1, this.f_5465691 / 2 - 75, this.f_3080061 - 28, 150, 20,
			C_3390001.m_2053009("gui.back")));
		Keyboard.enableRepeatEvents(true);
	}

	@Override
	public void m_2450377() {
		input.m_0296611();
	}

	@Override
	public void m_8984281() {
		if (widget != null) {
			widget.remove();
		}
		Keyboard.enableRepeatEvents(false);
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 1) {
			this.f_7153641.m_6408915(this.parent);
		} else if (buttonWidget.f_5920996 == 2) {
			f_7153641.m_6408915(new ChannelSettingsScreen(this, channel));
		}
	}

	@Override
	public void m_7362766(int mouseX, int mouseY, int button) {
		if (contextMenu.getMenu() != null) {
			if (contextMenu.mouseClicked(mouseX, mouseY, button)) {
				return;
			}
			contextMenu.removeMenu();
		}
		super.m_7362766(mouseX, mouseY, button);
		widget.m_7379893(mouseX, mouseY, button);
		input.m_1129375(mouseX, mouseY, button);
		users.m_7379893(mouseX, mouseY, button);
		chatListWidget.m_7379893(mouseX, mouseY, button);
	}

	@Override
	public void m_3356138() {
		super.m_3356138();

		widget.m_1002325();
		users.m_1002325();
		chatListWidget.m_1002325();
	}

	@Override
	protected void m_6992336(char c, int i) {
		super.m_6992336(c, i);
		input.m_1973329(c, i);
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return contextMenu;
	}

	@Override
	public C_3020744 getParent() {
		return parent;
	}

	@Override
	public C_3020744 getSelf() {
		return this;
	}
}
